/*
 * Decompiled with CFR 0.152.
 */
package cn.stylefeng.roses.kernel.rule.tree.factory;

import cn.stylefeng.roses.kernel.rule.tree.factory.base.AbstractTreeBuildFactory;
import cn.stylefeng.roses.kernel.rule.tree.factory.base.AbstractTreeNode;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;

public class DefaultTreeBuildFactory<T extends AbstractTreeNode<T>>
implements AbstractTreeBuildFactory<T> {
    private String rootParentId = "-1";

    public DefaultTreeBuildFactory() {
    }

    public DefaultTreeBuildFactory(String rootParentId) {
        this.rootParentId = rootParentId;
    }

    @Override
    public List<T> doTreeBuild(List<T> nodes) {
        for (AbstractTreeNode treeNode : nodes) {
            this.buildChildNodes(nodes, treeNode, new ArrayList());
        }
        ArrayList<AbstractTreeNode> results = new ArrayList<AbstractTreeNode>();
        for (AbstractTreeNode node : nodes) {
            if (!node.getNodeParentId().equals(this.rootParentId)) continue;
            results.add(node);
        }
        return results;
    }

    protected void buildChildNodes(List<T> totalNodes, T node, List<T> childNodeLists) {
        if (totalNodes == null || node == null) {
            return;
        }
        List<T> nodeSubLists = this.getSubChildsLevelOne(totalNodes, node);
        if (!nodeSubLists.isEmpty()) {
            for (AbstractTreeNode nodeSubList : nodeSubLists) {
                this.buildChildNodes(totalNodes, nodeSubList, new ArrayList());
            }
        }
        childNodeLists.addAll(nodeSubLists);
        node.setChildrenNodes(childNodeLists);
    }

    protected List<T> getSubChildsLevelOne(List<T> list2, T node) {
        ArrayList<AbstractTreeNode> nodeList = new ArrayList<AbstractTreeNode>();
        for (AbstractTreeNode nodeItem : list2) {
            if (!nodeItem.getNodeParentId().equals(node.getNodeId())) continue;
            nodeList.add(nodeItem);
        }
        return nodeList;
    }

    @Generated
    public String getRootParentId() {
        return this.rootParentId;
    }

    @Generated
    public void setRootParentId(String rootParentId) {
        this.rootParentId = rootParentId;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DefaultTreeBuildFactory)) {
            return false;
        }
        DefaultTreeBuildFactory other = (DefaultTreeBuildFactory)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$rootParentId = this.getRootParentId();
        String other$rootParentId = other.getRootParentId();
        return !(this$rootParentId == null ? other$rootParentId != null : !this$rootParentId.equals(other$rootParentId));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof DefaultTreeBuildFactory;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $rootParentId = this.getRootParentId();
        result = result * 59 + ($rootParentId == null ? 43 : $rootParentId.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "DefaultTreeBuildFactory(rootParentId=" + this.getRootParentId() + ")";
    }
}

