/*
 * Decompiled with CFR 0.152.
 */
package cn.stylefeng.roses.kernel.file.modular.controller;

import cn.stylefeng.roses.kernel.db.api.pojo.page.PageResult;
import cn.stylefeng.roses.kernel.file.api.FileInfoApi;
import cn.stylefeng.roses.kernel.file.api.pojo.AntdvFileInfo;
import cn.stylefeng.roses.kernel.file.api.pojo.request.SysFileInfoRequest;
import cn.stylefeng.roses.kernel.file.api.pojo.response.SysFileInfoResponse;
import cn.stylefeng.roses.kernel.file.modular.entity.SysFileInfo;
import cn.stylefeng.roses.kernel.file.modular.service.SysFileInfoService;
import cn.stylefeng.roses.kernel.rule.annotation.ApiLog;
import cn.stylefeng.roses.kernel.rule.enums.YesOrNotEnum;
import cn.stylefeng.roses.kernel.rule.pojo.request.BaseRequest;
import cn.stylefeng.roses.kernel.rule.pojo.response.ResponseData;
import cn.stylefeng.roses.kernel.rule.pojo.response.SuccessResponseData;
import cn.stylefeng.roses.kernel.rule.util.HttpServletUtil;
import cn.stylefeng.roses.kernel.scanner.api.annotation.ApiResource;
import cn.stylefeng.roses.kernel.scanner.api.annotation.GetResource;
import cn.stylefeng.roses.kernel.scanner.api.annotation.PostResource;
import jakarta.annotation.Resource;
import jakarta.servlet.http.HttpServletResponse;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@ApiResource(name="\u6587\u4ef6\u4fe1\u606f\u76f8\u5173\u63a5\u53e3")
public class SysFileInfoController {
    @Resource
    private SysFileInfoService sysFileInfoService;
    @Resource
    private FileInfoApi fileInfoApi;

    @PostResource(name="\u4e0a\u4f20\u6587\u4ef6", path={"/sysFileInfo/upload"})
    public ResponseData<SysFileInfoResponse> upload(@RequestPart(value="file") MultipartFile file, @Validated(value={BaseRequest.add.class}) SysFileInfoRequest sysFileInfoRequest) {
        SysFileInfoResponse fileUploadInfoResult = this.sysFileInfoService.uploadFile(file, sysFileInfoRequest);
        return new SuccessResponseData((Object)fileUploadInfoResult);
    }

    @PostResource(name="\u4e0a\u4f20\u6587\u4ef6", path={"/sysFileInfo/tinymceUpload"})
    public Map<String, String> tinymceUpload(@RequestPart(value="file") MultipartFile file, SysFileInfoRequest sysFileInfoRequest) {
        HashMap<String, String> resultMap = new HashMap<String, String>(1);
        sysFileInfoRequest.setSecretFlag(YesOrNotEnum.N.getCode());
        SysFileInfoResponse fileUploadInfoResult = this.sysFileInfoService.uploadFile(file, sysFileInfoRequest);
        resultMap.put("location", "/sysFileInfo/public/preview?fileId=" + fileUploadInfoResult.getFileId());
        return resultMap;
    }

    @GetResource(name="\u79c1\u6709\u6587\u4ef6\u9884\u89c8", path={"/sysFileInfo/private/preview"})
    public void privatePreview(@Validated(value={BaseRequest.detail.class}) SysFileInfoRequest sysFileInfoRequest) {
        HttpServletResponse response = HttpServletUtil.getResponse();
        sysFileInfoRequest.setSecretFlag(YesOrNotEnum.Y.getCode());
        this.sysFileInfoService.preview(sysFileInfoRequest, response);
    }

    @GetResource(name="\u516c\u6709\u6587\u4ef6\u9884\u89c8", path={"/sysFileInfo/public/preview"}, requiredLogin=false)
    public void publicPreview(@Validated(value={BaseRequest.detail.class}) SysFileInfoRequest sysFileInfoRequest) {
        HttpServletResponse response = HttpServletUtil.getResponse();
        sysFileInfoRequest.setSecretFlag(YesOrNotEnum.N.getCode());
        this.sysFileInfoService.preview(sysFileInfoRequest, response);
    }

    @GetResource(name="\u6587\u4ef6\u9884\u89c8\uff0c\u901a\u8fc7bucketName\u548cobjectName", path={"/sysFileInfo/previewByObjectName"}, requiredLogin=false)
    public void previewByBucketNameObjectName(@Validated(value={SysFileInfoRequest.previewByObjectName.class}) SysFileInfoRequest sysFileInfoRequest) {
        HttpServletResponse response = HttpServletUtil.getResponse();
        this.sysFileInfoService.previewByBucketAndObjName(sysFileInfoRequest, response);
    }

    @GetResource(name="\u79c1\u6709\u6587\u4ef6\u4e0b\u8f7d", path={"/sysFileInfo/privateDownload"})
    public void privateDownload(@Validated(value={BaseRequest.detail.class}) SysFileInfoRequest sysFileInfoRequest) {
        HttpServletResponse response = HttpServletUtil.getResponse();
        sysFileInfoRequest.setSecretFlag(YesOrNotEnum.Y.getCode());
        this.sysFileInfoService.download(sysFileInfoRequest, response);
    }

    @GetResource(name="\u516c\u6709\u6587\u4ef6\u4e0b\u8f7d", path={"/sysFileInfo/publicDownload"}, requiredLogin=false)
    public void publicDownload(@Validated(value={BaseRequest.detail.class}) SysFileInfoRequest sysFileInfoRequest) {
        HttpServletResponse response = HttpServletUtil.getResponse();
        sysFileInfoRequest.setSecretFlag(YesOrNotEnum.N.getCode());
        this.sysFileInfoService.download(sysFileInfoRequest, response);
    }

    @PostResource(name="\u66ff\u6362\u6587\u4ef6", path={"/sysFileInfo/update"})
    public ResponseData<SysFileInfoResponse> update(@RequestPart(value="file") MultipartFile file, @Validated(value={BaseRequest.edit.class}) SysFileInfoRequest sysFileInfoRequest) {
        SysFileInfoResponse fileUploadInfoResult = this.sysFileInfoService.updateFile(file, sysFileInfoRequest);
        return new SuccessResponseData((Object)fileUploadInfoResult);
    }

    @PostResource(name="\u7248\u672c\u56de\u9000", path={"/sysFileInfo/versionBack"})
    public ResponseData<SysFileInfoResponse> versionBack(@Validated(value={SysFileInfoRequest.versionBack.class}) SysFileInfoRequest sysFileInfoRequest) {
        SysFileInfoResponse fileUploadInfoResult = this.sysFileInfoService.versionBack(sysFileInfoRequest);
        return new SuccessResponseData((Object)fileUploadInfoResult);
    }

    @GetResource(name="\u6839\u636e\u9644\u4ef6IDS\u67e5\u8be2\u9644\u4ef6\u4fe1\u606f", path={"/sysFileInfo/getFileInfoListByFileIds"})
    public ResponseData<List<SysFileInfoResponse>> getFileInfoListByFileIds(@RequestParam(value="fileIds") String fileIds) {
        List<SysFileInfoResponse> list = this.sysFileInfoService.getFileInfoListByFileIds(fileIds);
        return new SuccessResponseData(list);
    }

    @GetResource(name="\u516c\u6709\u6253\u5305\u4e0b\u8f7d\u6587\u4ef6", path={"/sysFileInfo/publicPackagingDownload"}, requiredLogin=false)
    public void publicPackagingDownload(@RequestParam(value="fileIds") String fileIds) {
        HttpServletResponse response = HttpServletUtil.getResponse();
        this.sysFileInfoService.packagingDownload(fileIds, YesOrNotEnum.N.getCode(), response);
    }

    @GetResource(name="\u79c1\u6709\u6253\u5305\u4e0b\u8f7d\u6587\u4ef6", path={"/sysFileInfo/privatePackagingDownload"})
    public void privatePackagingDownload(@RequestParam(value="fileIds") String fileIds) {
        HttpServletResponse response = HttpServletUtil.getResponse();
        this.sysFileInfoService.packagingDownload(fileIds, YesOrNotEnum.Y.getCode(), response);
    }

    @PostResource(name="\u5220\u9664\u6587\u4ef6\u4fe1\u606f\uff08\u771f\u5220\u9664\u6587\u4ef6\u4fe1\u606f\uff09", path={"/sysFileInfo/deleteReally"})
    @ApiLog
    public ResponseData<?> deleteReally(@RequestBody @Validated(value={BaseRequest.delete.class}) SysFileInfoRequest sysFileInfoRequest) {
        this.sysFileInfoService.deleteReally(sysFileInfoRequest);
        return new SuccessResponseData();
    }

    @GetResource(name="\u5206\u9875\u67e5\u8be2\u6587\u4ef6\u4fe1\u606f\u8868", path={"/sysFileInfo/fileInfoListPage"})
    public ResponseData<PageResult<SysFileInfo>> fileInfoListPage(SysFileInfoRequest sysFileInfoRequest) {
        return new SuccessResponseData(this.sysFileInfoService.fileInfoListPage(sysFileInfoRequest));
    }

    @GetResource(name="\u67e5\u770b\u8be6\u60c5\u6587\u4ef6\u4fe1\u606f\u8868", path={"/sysFileInfo/detail"})
    public ResponseData<SysFileInfo> detail(@Validated(value={BaseRequest.detail.class}) SysFileInfoRequest sysFileInfoRequest) {
        return new SuccessResponseData((Object)this.sysFileInfoService.detail(sysFileInfoRequest));
    }

    @GetResource(name="\u83b7\u53d6antdv\u7c7b\u578b\u7684\u6587\u4ef6\u8be6\u60c5\u4fe1\u606f", path={"/sysFileInfo/getAntdVInfo"})
    public ResponseData<AntdvFileInfo> getAntdVInfo(@Validated(value={BaseRequest.detail.class}) SysFileInfoRequest sysFileInfoRequest) {
        return new SuccessResponseData((Object)this.fileInfoApi.buildAntdvFileInfo(sysFileInfoRequest.getFileId()));
    }

    @PostResource(name="\u901a\u8fc7\u6587\u4ef6id\u96c6\u5408\uff0c\u6279\u91cf\u83b7\u53d6\u6587\u4ef6\u4fe1\u606f\u8be6\u60c5", path={"/sysFileInfo/getAntdVInfoBatch"})
    public ResponseData<List<AntdvFileInfo>> getAntdVInfoBatch(@RequestBody @Validated(value={SysFileInfoRequest.batchGetFileAntdvInfo.class}) SysFileInfoRequest sysFileInfoRequest) {
        return new SuccessResponseData((Object)this.fileInfoApi.buildAntdvFileInfoBatch(sysFileInfoRequest.getFileIdList()));
    }
}

