/*
 * Decompiled with CFR 0.152.
 */
package cn.stylefeng.roses.kernel.dsctn.listener;

import cn.hutool.core.convert.Convert;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import cn.stylefeng.roses.kernel.db.api.factory.DruidDatasourceFactory;
import cn.stylefeng.roses.kernel.db.api.pojo.druid.DruidProperties;
import cn.stylefeng.roses.kernel.dsctn.api.exception.DatasourceContainerException;
import cn.stylefeng.roses.kernel.dsctn.api.exception.enums.DatasourceContainerExceptionEnum;
import cn.stylefeng.roses.kernel.dsctn.context.DataSourceContext;
import cn.stylefeng.roses.kernel.rule.exception.AbstractExceptionEnum;
import cn.stylefeng.roses.kernel.rule.listener.ContextInitializedListener;
import com.alibaba.druid.pool.DruidDataSource;
import javax.sql.DataSource;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.event.ApplicationContextInitializedEvent;
import org.springframework.core.Ordered;
import org.springframework.core.env.ConfigurableEnvironment;

public class DataSourceInitListener
extends ContextInitializedListener
implements Ordered {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DataSourceInitListener.class);

    public int getOrder() {
        return -2147483448;
    }

    public void eventCallback(ApplicationContextInitializedEvent event) {
        ConfigurableEnvironment environment = event.getApplicationContext().getEnvironment();
        String dataSourceDriver = environment.getProperty("spring.datasource.driver-class-name");
        String dataSourceUrl = environment.getProperty("spring.datasource.url");
        String dataSourceUsername = environment.getProperty("spring.datasource.username");
        String dataSourcePassword = environment.getProperty("spring.datasource.password");
        if (ObjectUtil.hasEmpty((Object[])new Object[]{dataSourceUrl, dataSourceUsername, dataSourcePassword})) {
            String userTip = StrUtil.format((CharSequence)DatasourceContainerExceptionEnum.DB_CONNECTION_INFO_EMPTY_ERROR.getUserTip(), (Object[])new Object[]{dataSourceUrl, dataSourceUsername});
            throw new DatasourceContainerException((AbstractExceptionEnum)DatasourceContainerExceptionEnum.DB_CONNECTION_INFO_EMPTY_ERROR, new Object[]{userTip});
        }
        DruidProperties druidProperties = new DruidProperties();
        druidProperties.setDriverClassName(dataSourceDriver);
        druidProperties.setUrl(dataSourceUrl);
        druidProperties.setUsername(dataSourceUsername);
        druidProperties.setPassword(dataSourcePassword);
        this.setOtherDruidConfigs(environment, druidProperties);
        DruidDataSource druidDataSource = DruidDatasourceFactory.createDruidDataSource((DruidProperties)druidProperties);
        try {
            DataSourceContext.initDataSource(druidProperties, (DataSource)druidDataSource);
        }
        catch (Exception exception) {
            log.error("\u521d\u59cb\u5316\u6570\u636e\u6e90\u5bb9\u5668\u9519\u8bef!", (Throwable)exception);
            String userTip = StrUtil.format((CharSequence)DatasourceContainerExceptionEnum.INIT_DATASOURCE_CONTAINER_ERROR.getUserTip(), (Object[])new Object[]{exception.getMessage()});
            throw new DatasourceContainerException((AbstractExceptionEnum)DatasourceContainerExceptionEnum.INIT_DATASOURCE_CONTAINER_ERROR, new Object[]{userTip});
        }
    }

    private void setOtherDruidConfigs(ConfigurableEnvironment environment, DruidProperties druidProperties) {
        Integer intValue;
        String initialSize = environment.getProperty("spring.datasource.initialSize");
        String maxActive = environment.getProperty("spring.datasource.maxActive");
        String minIdle = environment.getProperty("spring.datasource.minIdle");
        String maxWait = environment.getProperty("spring.datasource.maxWait");
        String poolPreparedStatements = environment.getProperty("spring.datasource.poolPreparedStatements");
        String maxPoolPreparedStatementPerConnectionSize = environment.getProperty("spring.datasource.maxPoolPreparedStatementPerConnectionSize");
        String validationQuery = environment.getProperty("spring.datasource.validationQuery");
        String validationQueryTimeout = environment.getProperty("spring.datasource.validationQueryTimeout");
        String testOnBorrow = environment.getProperty("spring.datasource.testOnBorrow");
        String testOnReturn = environment.getProperty("spring.datasource.testOnReturn");
        String testWhileIdle = environment.getProperty("spring.datasource.testWhileIdle");
        String keepAlive = environment.getProperty("spring.datasource.keepAlive");
        String timeBetweenEvictionRunsMillis = environment.getProperty("spring.datasource.timeBetweenEvictionRunsMillis");
        String minEvictableIdleTimeMillis = environment.getProperty("spring.datasource.minEvictableIdleTimeMillis");
        String filters = environment.getProperty("spring.datasource.filters");
        if (ObjectUtil.isNotEmpty((Object)initialSize)) {
            intValue = Convert.toInt((Object)initialSize);
            druidProperties.setInitialSize(intValue);
        }
        if (ObjectUtil.isNotEmpty((Object)maxActive)) {
            intValue = Convert.toInt((Object)maxActive);
            druidProperties.setMaxActive(intValue);
        }
        if (ObjectUtil.isNotEmpty((Object)minIdle)) {
            intValue = Convert.toInt((Object)minIdle);
            druidProperties.setMinIdle(intValue);
        }
        if (ObjectUtil.isNotEmpty((Object)maxWait)) {
            intValue = Convert.toInt((Object)maxWait);
            druidProperties.setMaxWait(intValue);
        }
        if (ObjectUtil.isNotEmpty((Object)poolPreparedStatements)) {
            boolean booleanValue = Convert.toBool((Object)poolPreparedStatements);
            druidProperties.setPoolPreparedStatements(Boolean.valueOf(booleanValue));
        }
        if (ObjectUtil.isNotEmpty((Object)maxPoolPreparedStatementPerConnectionSize)) {
            Integer intValue2 = Convert.toInt((Object)maxPoolPreparedStatementPerConnectionSize);
            druidProperties.setMaxPoolPreparedStatementPerConnectionSize(intValue2);
        }
        if (ObjectUtil.isNotEmpty((Object)validationQuery)) {
            druidProperties.setValidationQuery(validationQuery);
        }
        if (ObjectUtil.isNotEmpty((Object)validationQueryTimeout)) {
            Integer intValue3 = Convert.toInt((Object)validationQueryTimeout);
            druidProperties.setValidationQueryTimeout(intValue3);
        }
        if (ObjectUtil.isNotEmpty((Object)testOnBorrow)) {
            boolean booleanValue = Convert.toBool((Object)testOnBorrow);
            druidProperties.setTestOnBorrow(Boolean.valueOf(booleanValue));
        }
        if (ObjectUtil.isNotEmpty((Object)testOnReturn)) {
            boolean booleanValue = Convert.toBool((Object)testOnReturn);
            druidProperties.setTestOnReturn(Boolean.valueOf(booleanValue));
        }
        if (ObjectUtil.isNotEmpty((Object)testWhileIdle)) {
            boolean booleanValue = Convert.toBool((Object)testWhileIdle);
            druidProperties.setTestWhileIdle(Boolean.valueOf(booleanValue));
        }
        if (ObjectUtil.isNotEmpty((Object)keepAlive)) {
            boolean booleanValue = Convert.toBool((Object)keepAlive);
            druidProperties.setKeepAlive(Boolean.valueOf(booleanValue));
        }
        if (ObjectUtil.isNotEmpty((Object)timeBetweenEvictionRunsMillis)) {
            Integer intValue4 = Convert.toInt((Object)timeBetweenEvictionRunsMillis);
            druidProperties.setTimeBetweenEvictionRunsMillis(intValue4);
        }
        if (ObjectUtil.isNotEmpty((Object)minEvictableIdleTimeMillis)) {
            Integer intValue5 = Convert.toInt((Object)minEvictableIdleTimeMillis);
            druidProperties.setMinEvictableIdleTimeMillis(intValue5);
        }
        if (ObjectUtil.isNotEmpty((Object)filters)) {
            druidProperties.setFilters(filters);
        }
    }
}

