/*
 * Decompiled with CFR 0.152.
 */
package cn.stylefeng.roses.kernel.city.modular.service.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.stylefeng.roses.kernel.city.modular.entity.Area;
import cn.stylefeng.roses.kernel.city.modular.enums.AreaExceptionEnum;
import cn.stylefeng.roses.kernel.city.modular.mapper.AreaMapper;
import cn.stylefeng.roses.kernel.city.modular.pojo.request.AreaRequest;
import cn.stylefeng.roses.kernel.city.modular.service.AreaService;
import cn.stylefeng.roses.kernel.db.api.factory.PageFactory;
import cn.stylefeng.roses.kernel.db.api.factory.PageResultFactory;
import cn.stylefeng.roses.kernel.db.api.pojo.page.PageResult;
import cn.stylefeng.roses.kernel.rule.constants.TreeConstants;
import cn.stylefeng.roses.kernel.rule.exception.AbstractExceptionEnum;
import cn.stylefeng.roses.kernel.rule.exception.base.ServiceException;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import java.util.List;
import org.springframework.stereotype.Service;

@Service
public class AreaServiceImpl
extends ServiceImpl<AreaMapper, Area>
implements AreaService {
    @Override
    public void add(AreaRequest areaRequest) {
        Area area = new Area();
        BeanUtil.copyProperties((Object)((Object)areaRequest), (Object)((Object)area), (String[])new String[0]);
        this.save((Object)area);
    }

    @Override
    public void del(AreaRequest areaRequest) {
        Area area = this.queryArea(areaRequest);
        this.removeById(area.getAreaId());
    }

    @Override
    public void edit(AreaRequest areaRequest) {
        Area area = this.queryArea(areaRequest);
        BeanUtil.copyProperties((Object)((Object)areaRequest), (Object)((Object)area), (String[])new String[0]);
        this.updateById((Object)area);
    }

    @Override
    public Area detail(AreaRequest areaRequest) {
        return this.queryArea(areaRequest);
    }

    @Override
    public PageResult<Area> findPage(AreaRequest areaRequest) {
        LambdaQueryWrapper<Area> wrapper = this.createWrapper(areaRequest);
        Page page = (Page)this.page((IPage)PageFactory.defaultPage(), (Wrapper)wrapper);
        return PageResultFactory.createPageResult((Page)page);
    }

    @Override
    public List<Area> findList(AreaRequest areaRequest) {
        String parentId = areaRequest.getParentId();
        if (ObjectUtil.isEmpty((Object)parentId)) {
            areaRequest.setParentId(TreeConstants.DEFAULT_PARENT_ID.toString());
        }
        LambdaQueryWrapper<Area> wrapper = this.createWrapper(areaRequest);
        wrapper.select(new SFunction[]{Area::getAreaId, Area::getAreaName, Area::getAreaCode});
        return this.list((Wrapper)wrapper);
    }

    private Area queryArea(AreaRequest areaRequest) {
        Area area = (Area)((Object)this.getById(areaRequest.getAreaId()));
        if (ObjectUtil.isEmpty((Object)((Object)area))) {
            throw new ServiceException((AbstractExceptionEnum)AreaExceptionEnum.AREA_NOT_EXISTED);
        }
        return area;
    }

    private LambdaQueryWrapper<Area> createWrapper(AreaRequest areaRequest) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        String parentId = areaRequest.getParentId();
        queryWrapper.eq(ObjectUtil.isNotEmpty((Object)parentId), Area::getParentId, (Object)parentId);
        queryWrapper.orderByAsc(Area::getAreaSort);
        return queryWrapper;
    }
}

