/*
 * Decompiled with CFR 0.152.
 */
package cn.stylefeng.roses.kernel.db.mp.dbid;

import cn.stylefeng.roses.kernel.rule.enums.DbTypeEnum;
import java.lang.reflect.Method;
import java.sql.SQLException;
import javax.sql.DataSource;
import lombok.Generated;
import org.apache.ibatis.mapping.DatabaseIdProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CustomDatabaseIdProvider
implements DatabaseIdProvider {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CustomDatabaseIdProvider.class);

    public String getDatabaseId(DataSource dataSource) throws SQLException {
        String url = "";
        try {
            url = dataSource.getConnection().getMetaData().getURL();
        }
        catch (Exception e) {
            try {
                Class<?> XAClass = Class.forName("io.seata.rm.datasource.xa.DataSourceProxyXA");
                if (XAClass.isInstance(dataSource)) {
                    Method xaMethod = XAClass.getMethod("getResourceId", new Class[0]);
                    Object xaResult = xaMethod.invoke((Object)dataSource, new Object[0]);
                    url = xaResult.toString();
                }
            }
            catch (Exception e2) {
                log.warn("CustomDatabaseIdProvider\u65e0\u6cd5\u5224\u65ad\u5f53\u524d\u6570\u636e\u6e90\u7c7b\u578b\uff0c\u9ed8\u8ba4\u9009\u62e9Mysql\u7c7b\u578b");
                return DbTypeEnum.MYSQL.getXmlDatabaseId();
            }
        }
        if (url.contains(DbTypeEnum.ORACLE.getUrlWords())) {
            return DbTypeEnum.ORACLE.getXmlDatabaseId();
        }
        if (url.contains(DbTypeEnum.DM.getUrlWords())) {
            return DbTypeEnum.ORACLE.getXmlDatabaseId();
        }
        if (url.contains(DbTypeEnum.MS_SQL.getUrlWords())) {
            return DbTypeEnum.MS_SQL.getXmlDatabaseId();
        }
        if (url.contains(DbTypeEnum.PG_SQL.getUrlWords())) {
            return DbTypeEnum.PG_SQL.getXmlDatabaseId();
        }
        return DbTypeEnum.MYSQL.getXmlDatabaseId();
    }
}

