/*
 * Decompiled with CFR 0.152.
 */
package cn.stylefeng.roses.kernel.auth.starter.cache;

import cn.stylefeng.roses.kernel.auth.api.pojo.login.LoginUser;
import cn.stylefeng.roses.kernel.auth.cache.LoginErrorCountRedisCache;
import cn.stylefeng.roses.kernel.auth.session.cache.catoken.RedisCaClientTokenCache;
import cn.stylefeng.roses.kernel.auth.session.cache.logintoken.RedisLoginTokenCache;
import cn.stylefeng.roses.kernel.auth.session.cache.loginuser.RedisLoginUserCache;
import cn.stylefeng.roses.kernel.cache.api.CacheOperatorApi;
import cn.stylefeng.roses.kernel.cache.redis.util.CreateRedisTemplateUtil;
import java.util.Set;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.core.RedisTemplate;

@Configuration
@ConditionalOnClass(name={"org.springframework.data.redis.connection.RedisConnectionFactory"})
public class AuthTokenRedisCacheAutoConfiguration {
    @Bean
    public CacheOperatorApi<LoginUser> loginUserCache(RedisConnectionFactory redisConnectionFactory) {
        RedisTemplate redisTemplate = CreateRedisTemplateUtil.createObject((RedisConnectionFactory)redisConnectionFactory);
        return new RedisLoginUserCache(redisTemplate);
    }

    @Bean
    public CacheOperatorApi<Set<String>> allPlaceLoginTokenCache(RedisConnectionFactory redisConnectionFactory) {
        RedisTemplate redisTemplate = CreateRedisTemplateUtil.createObject((RedisConnectionFactory)redisConnectionFactory);
        return new RedisLoginTokenCache(redisTemplate);
    }

    @Bean
    public CacheOperatorApi<Integer> loginErrorCountCacheApi(RedisConnectionFactory redisConnectionFactory) {
        RedisTemplate redisTemplate = CreateRedisTemplateUtil.createObject((RedisConnectionFactory)redisConnectionFactory);
        return new LoginErrorCountRedisCache(redisTemplate);
    }

    @Bean
    public CacheOperatorApi<String> caClientTokenCacheApi(RedisConnectionFactory redisConnectionFactory) {
        RedisTemplate redisTemplate = CreateRedisTemplateUtil.createString((RedisConnectionFactory)redisConnectionFactory);
        return new RedisCaClientTokenCache(redisTemplate);
    }
}

