/*
 * Decompiled with CFR 0.152.
 */
package com.itheima.auth.boot.autoconfigure;

import com.itheima.auth.boot.autoconfigure.AuthorityProperties;
import com.itheima.auth.sdk.AuthTemplate;
import com.itheima.auth.sdk.service.TokenCheckService;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnClass(value={AuthTemplate.class})
@EnableConfigurationProperties(value={AuthorityProperties.class})
public class AuthorityConfigAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    public AuthTemplate authTemplate(AuthorityProperties properties) {
        return new AuthTemplate(properties.getHost(), properties.getPort(), properties.getTimeout(), null, properties.getApplicationId());
    }

    @Bean
    @ConditionalOnMissingBean
    public TokenCheckService tokenCheckService(AuthorityProperties properties) {
        return new TokenCheckService(properties.getPublicKeyFile());
    }
}

