/*
 * Decompiled with CFR 0.152.
 */
package com.itheima.auth.sdk.service;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.io.resource.ResourceUtil;
import com.itheima.auth.sdk.common.AuthSdkException;
import com.itheima.auth.sdk.dto.AuthUserInfoDTO;
import io.jsonwebtoken.ExpiredJwtException;
import io.jsonwebtoken.Jws;
import io.jsonwebtoken.Jwts;
import java.security.Key;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.X509EncodedKeySpec;

public class TokenCheckService {
    private String publicKeyFile;

    public TokenCheckService(String publicKeyFile) {
        this.publicKeyFile = publicKeyFile;
    }

    public AuthUserInfoDTO parserToken(String token) throws AuthSdkException {
        try {
            PublicKey publicKey = this.getPublicKey();
            if (publicKey == null) {
                return null;
            }
            Jws jws = Jwts.parser().setSigningKey((Key)publicKey).parseClaimsJws(token);
            return (AuthUserInfoDTO)BeanUtil.toBean((Object)jws.getBody(), AuthUserInfoDTO.class);
        }
        catch (ExpiredJwtException var3) {
            throw new AuthSdkException("token\u5df2\u8fc7\u671f");
        }
        catch (Exception var6) {
            var6.printStackTrace();
            throw new AuthSdkException("token\u4e0d\u5408\u6cd5");
        }
    }

    private PublicKey getPublicKey() throws NoSuchAlgorithmException, InvalidKeySpecException {
        X509EncodedKeySpec spec = new X509EncodedKeySpec(ResourceUtil.readBytes((String)this.publicKeyFile));
        KeyFactory kf = KeyFactory.getInstance("RSA");
        PublicKey publicKey = kf.generatePublic(spec);
        return publicKey;
    }
}

