/*
 * Decompiled with CFR 0.152.
 */
package com.itheima.auth.sdk.service;

import cn.hutool.http.Header;
import cn.hutool.http.HttpRequest;
import cn.hutool.json.JSONUtil;
import com.itheima.auth.sdk.common.TokenCheck;
import com.itheima.auth.sdk.config.AuthorityConfig;
import com.itheima.auth.sdk.service.HttpApiService;
import java.util.HashMap;
import java.util.Map;

public class JsonHttpApiService
extends HttpApiService {
    private AuthorityConfig authorityConfig;

    public JsonHttpApiService(AuthorityConfig authorityConfig) {
        this.authorityConfig = authorityConfig;
    }

    @Override
    protected void setRequestParam(HttpRequest httpRequest, Map<String, Object> param) {
        httpRequest.body(JSONUtil.toJsonStr(param));
    }

    @Override
    public void setRequestHeader(HttpRequest httpRequest) {
        httpRequest.header(Header.CONTENT_TYPE, "application/json");
    }

    @Override
    public void addHeaders(HttpRequest httpRequest) {
        HashMap<String, String> headers = new HashMap<String, String>();
        if (this.authorityConfig.getToken() != null && !"".equals(this.authorityConfig.getToken())) {
            new TokenCheck().parserToken(this.authorityConfig.getToken());
            headers.put("token", this.authorityConfig.getToken());
        }
        if (this.authorityConfig.getApplicationId() != null && !"".equals(this.authorityConfig.getApplicationId())) {
            headers.put("APPLICATIONID", String.valueOf(this.authorityConfig.getApplicationId()));
        }
        headers.put("APPLICATIONTYPE", "APPLICATION");
        httpRequest.addHeaders(headers);
    }

    @Override
    protected int getTimeOut() {
        return this.authorityConfig.getTimeout();
    }
}

