/*
 * Decompiled with CFR 0.152.
 */
package com.itheima.auth.sdk.service;

import cn.hutool.core.convert.Convert;
import cn.hutool.http.Header;
import cn.hutool.http.HttpRequest;
import cn.hutool.http.HttpResponse;
import cn.hutool.http.Method;
import java.util.HashMap;
import java.util.Map;

public abstract class HttpApiService {
    public String execute(String url, Method method, Map<String, Object> param) {
        HttpRequest httpRequest;
        switch (method) {
            case GET: {
                httpRequest = HttpRequest.get((String)url);
                break;
            }
            case POST: {
                httpRequest = HttpRequest.post((String)url);
                break;
            }
            case PUT: {
                httpRequest = HttpRequest.put((String)url);
                break;
            }
            case DELETE: {
                httpRequest = HttpRequest.delete((String)url);
                break;
            }
            default: {
                return null;
            }
        }
        this.setRequestHeader(httpRequest);
        this.addHeaders(httpRequest);
        this.setRequestParam(httpRequest, param);
        try {
            HttpResponse response = httpRequest.timeout(Convert.toInt((Object)this.getTimeOut(), (Integer)10000).intValue()).execute();
            if (response != null && response.isOk()) {
                return response.body();
            }
            return null;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void setRequestHeader(HttpRequest httpRequest) {
        httpRequest.header(Header.CONTENT_TYPE, "application/x-www-form-urlencoded");
    }

    public void addHeaders(HttpRequest httpRequest) {
        httpRequest.addHeaders(new HashMap());
    }

    protected abstract void setRequestParam(HttpRequest var1, Map<String, Object> var2);

    protected abstract int getTimeOut();

    public String doGet(String url, Map<String, Object> param) {
        return this.execute(url, Method.GET, param);
    }

    public String doPost(String url, Map<String, Object> param) {
        return this.execute(url, Method.POST, param);
    }
}

