/*
 * Decompiled with CFR 0.152.
 */
package com.itheima.auth.sdk.ops.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.lang.TypeReference;
import cn.hutool.json.JSON;
import cn.hutool.json.JSONObject;
import cn.hutool.json.JSONUtil;
import com.itheima.auth.sdk.AuthTemplate;
import com.itheima.auth.sdk.common.Result;
import com.itheima.auth.sdk.config.AuthorityConfig;
import com.itheima.auth.sdk.dto.PageDTO;
import com.itheima.auth.sdk.dto.UserDTO;
import com.itheima.auth.sdk.dto.UserPageDTO;
import com.itheima.auth.sdk.ops.UserOperations;
import java.util.HashMap;
import java.util.List;

public class UserOperationsImpl
implements UserOperations {
    private AuthTemplate authTemplate;
    private AuthorityConfig authorityConfig;

    public UserOperationsImpl(AuthTemplate authTemplate) {
        this.authTemplate = authTemplate;
        this.authorityConfig = authTemplate.getAuthorityConfig();
    }

    @Override
    public Result<UserDTO> getUserById(Long userId) {
        try {
            String url = this.authorityConfig.getUri() + "/api/authority/user/" + userId;
            String responseBody = this.authTemplate.getFormHttpApiService().doGet(url, new HashMap<String, Object>());
            JSONObject jsonObject = JSONUtil.parseObj((String)responseBody);
            if (jsonObject.getInt((Object)"code") == 0) {
                UserDTO userDTO = (UserDTO)JSONUtil.toBean((String)jsonObject.getStr((Object)"data"), UserDTO.class);
                return Result.success(userDTO);
            }
            return Result.fail(jsonObject.getStr((Object)"msg"));
        }
        catch (Exception e) {
            return Result.fail(e.getMessage());
        }
    }

    @Override
    public Result<PageDTO<UserDTO>> getUserByPage(UserPageDTO pageDTO) {
        String url = this.authorityConfig.getUri() + "/api/authority/user/page";
        String responseBody = this.authTemplate.getFormHttpApiService().doGet(url, BeanUtil.beanToMap((Object)pageDTO));
        JSONObject jsonObject = JSONUtil.parseObj((String)responseBody);
        if (jsonObject.getInt((Object)"code") == 0) {
            PageDTO pageResult = (PageDTO)JSONUtil.toBean((JSON)jsonObject.getJSONObject((Object)"data"), (TypeReference)new TypeReference<PageDTO<UserDTO>>(){}, (boolean)true);
            return Result.success(pageResult);
        }
        return Result.fail(jsonObject.getStr((Object)"msg"));
    }

    @Override
    public Result<List<UserDTO>> list(List<Long> ids) {
        String url = this.authorityConfig.getUri() + "/api/authority/user";
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("ids", ids);
        String responseBody = this.authTemplate.getFormHttpApiService().doGet(url, hashMap);
        JSONObject jsonObject = JSONUtil.parseObj((String)responseBody);
        if (jsonObject.getInt((Object)"code") == 0) {
            List userDTOList = (List)JSONUtil.toBean((JSON)jsonObject.getJSONArray((Object)"data"), (TypeReference)new TypeReference<List<UserDTO>>(){}, (boolean)true);
            return Result.success(userDTOList);
        }
        return Result.fail(jsonObject.getStr((Object)"msg"));
    }
}

