/*
 * Decompiled with CFR 0.152.
 */
package com.itheima.auth.sdk.ops.impl;

import cn.hutool.json.JSONObject;
import cn.hutool.json.JSONUtil;
import com.itheima.auth.sdk.AuthTemplate;
import com.itheima.auth.sdk.common.Result;
import com.itheima.auth.sdk.config.AuthorityConfig;
import com.itheima.auth.sdk.dto.RoleResourceDTO;
import com.itheima.auth.sdk.ops.RoleOperations;
import java.util.HashMap;
import java.util.List;

public class RoleOperationsImpl
implements RoleOperations {
    private AuthTemplate authTemplate;
    private AuthorityConfig authorityConfig;

    public RoleOperationsImpl(AuthTemplate authTemplate) {
        this.authTemplate = authTemplate;
        this.authorityConfig = authTemplate.getAuthorityConfig();
    }

    @Override
    public Result<List<Long>> findRoleByUserId(Long userId) {
        try {
            String url = this.authorityConfig.getUri() + "/api/authority/role/findRoleByUserId/" + userId;
            String responseBody = this.authTemplate.getFormHttpApiService().doGet(url, new HashMap<String, Object>());
            JSONObject jsonObject = JSONUtil.parseObj((String)responseBody);
            if (jsonObject.getInt((Object)"code") == 0) {
                List roleIds = JSONUtil.toList((String)jsonObject.getStr((Object)"data"), Long.class);
                return Result.success(roleIds);
            }
            return Result.fail(jsonObject.getStr((Object)"msg"));
        }
        catch (Exception e) {
            return Result.fail(e.getMessage());
        }
    }

    @Override
    public Result<List<RoleResourceDTO>> findAllRoles() {
        try {
            String url = this.authorityConfig.getUri() + "/role/findAllRoles";
            String responseBody = this.authTemplate.getFormHttpApiService().doGet(url, new HashMap<String, Object>());
            JSONObject jsonObject = JSONUtil.parseObj((String)responseBody);
            if (jsonObject.getInt((Object)"code") == 0) {
                List roleIds = JSONUtil.toList((String)jsonObject.getStr((Object)"data"), RoleResourceDTO.class);
                return Result.success(roleIds);
            }
            return Result.fail(jsonObject.getStr((Object)"msg"));
        }
        catch (Exception e) {
            return Result.fail(e.getMessage());
        }
    }
}

