/*
 * Decompiled with CFR 0.152.
 */
package com.itheima.auth.sdk.ops.impl;

import cn.hutool.json.JSONObject;
import cn.hutool.json.JSONUtil;
import com.itheima.auth.sdk.AuthTemplate;
import com.itheima.auth.sdk.common.Result;
import com.itheima.auth.sdk.config.AuthorityConfig;
import com.itheima.auth.sdk.dto.MenuDTO;
import com.itheima.auth.sdk.dto.ResourceDTO;
import com.itheima.auth.sdk.ops.PermissionOperations;
import java.util.HashMap;
import java.util.List;

public class PermissionOperationsImpl
implements PermissionOperations {
    private AuthTemplate authTemplate;
    private AuthorityConfig authorityConfig;

    public PermissionOperationsImpl(AuthTemplate authTemplate) {
        this.authTemplate = authTemplate;
        this.authorityConfig = authTemplate.getAuthorityConfig();
    }

    @Override
    public Result<List<MenuDTO>> getMenu() {
        try {
            if (this.authorityConfig.getApplicationId() == null) {
                return Result.fail("ApplicationId\u4e0d\u80fd\u4e3a\u7a7a");
            }
            String url = this.authorityConfig.getUri() + "/api/authority/menu/router";
            String responseBody = this.authTemplate.getFormHttpApiService().doGet(url, new HashMap<String, Object>());
            JSONObject jsonObject = JSONUtil.parseObj((String)responseBody);
            if (jsonObject.getInt((Object)"code") == 0) {
                List routers = JSONUtil.toList((String)jsonObject.getStr((Object)"data"), MenuDTO.class);
                return Result.success(routers);
            }
            return Result.fail(jsonObject.getStr((Object)"msg"));
        }
        catch (Exception e) {
            return Result.fail(e.getMessage());
        }
    }

    @Override
    public Result<List<ResourceDTO>> getPermissions() {
        if (this.authorityConfig.getApplicationId() == null) {
            return Result.fail("ApplicationId\u4e0d\u80fd\u4e3a\u7a7a");
        }
        try {
            String url = this.authorityConfig.getUri() + "/api/authority/resource/permissions";
            String responseBody = this.authTemplate.getFormHttpApiService().doGet(url, new HashMap<String, Object>());
            JSONObject jsonObject = JSONUtil.parseObj((String)responseBody);
            if (jsonObject.getInt((Object)"code") == 0) {
                List permissions = JSONUtil.toList((String)jsonObject.getStr((Object)"data"), ResourceDTO.class);
                return Result.success(permissions);
            }
            return Result.fail(jsonObject.getStr((Object)"msg"));
        }
        catch (Exception e) {
            return Result.fail(e.getMessage());
        }
    }
}

