/*
 * Decompiled with CFR 0.152.
 */
package com.itheima.auth.sdk.ops.impl;

import cn.hutool.json.JSONObject;
import cn.hutool.json.JSONUtil;
import com.itheima.auth.sdk.AuthTemplate;
import com.itheima.auth.sdk.common.Result;
import com.itheima.auth.sdk.config.AuthorityConfig;
import com.itheima.auth.sdk.dto.OrgDTO;
import com.itheima.auth.sdk.dto.OrgTreeDTO;
import com.itheima.auth.sdk.ops.OrgOperations;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;

public class OrgOperationsImpl
implements OrgOperations {
    private AuthTemplate authTemplate;
    private AuthorityConfig authorityConfig;

    public OrgOperationsImpl(AuthTemplate authTemplate) {
        this.authTemplate = authTemplate;
        this.authorityConfig = authTemplate.getAuthorityConfig();
    }

    @Override
    public Result<OrgDTO> getOrgById(Long id) {
        try {
            String url = this.authorityConfig.getUri() + "/api/authority/org/" + id;
            String response = this.authTemplate.getFormHttpApiService().doGet(url, new HashMap<String, Object>());
            JSONObject jsonObject = JSONUtil.parseObj((String)response);
            if (jsonObject.getInt((Object)"code") == 0) {
                OrgDTO orgDTO = (OrgDTO)JSONUtil.toBean((String)jsonObject.getStr((Object)"data"), OrgDTO.class);
                return Result.success(orgDTO);
            }
            return Result.fail(jsonObject.getStr((Object)"msg"));
        }
        catch (Exception e) {
            return Result.fail(e.getMessage());
        }
    }

    @Override
    public Result<List<OrgDTO>> getOrgByIds(List<Long> ids) {
        try {
            String param = ids.stream().map(String::valueOf).collect(Collectors.joining(","));
            String url = this.authorityConfig.getUri() + "/api/authority/org/listByIds?ids=" + param;
            String response = this.authTemplate.getFormHttpApiService().doGet(url, new HashMap<String, Object>());
            JSONObject jsonObject = JSONUtil.parseObj((String)response);
            if (jsonObject.getInt((Object)"code") == 0) {
                List orgDTOList = JSONUtil.toList((String)jsonObject.getStr((Object)"data"), OrgDTO.class);
                return Result.success(orgDTOList);
            }
            return Result.fail(jsonObject.getStr((Object)"msg"));
        }
        catch (Exception e) {
            return Result.fail(e.getMessage());
        }
    }

    @Override
    public Result<List<OrgTreeDTO>> getOrgTrees() {
        try {
            String url = this.authorityConfig.getUri() + "/api/authority/org/tree";
            String response = this.authTemplate.getFormHttpApiService().doGet(url, new HashMap<String, Object>());
            JSONObject jsonObject = JSONUtil.parseObj((String)response);
            if (jsonObject.getInt((Object)"code") == 0) {
                List tress = JSONUtil.toList((String)jsonObject.getStr((Object)"data"), OrgTreeDTO.class);
                return Result.success(tress);
            }
            return Result.fail(jsonObject.getStr((Object)"msg"));
        }
        catch (Exception e) {
            return Result.fail(e.getMessage());
        }
    }
}

