/*
 * Decompiled with CFR 0.152.
 */
package com.itheima.auth.sdk.ops.impl;

import cn.hutool.json.JSONObject;
import cn.hutool.json.JSONUtil;
import com.itheima.auth.sdk.AuthTemplate;
import com.itheima.auth.sdk.common.Result;
import com.itheima.auth.sdk.config.AuthorityConfig;
import com.itheima.auth.sdk.dto.LoginDTO;
import com.itheima.auth.sdk.ops.LoginOperations;
import java.util.HashMap;

public class LoginOperationsImpl
implements LoginOperations {
    private AuthTemplate authTemplate;
    private AuthorityConfig authorityConfig;

    public LoginOperationsImpl(AuthTemplate authTemplate) {
        this.authTemplate = authTemplate;
        this.authorityConfig = authTemplate.getAuthorityConfig();
    }

    @Override
    public Result<LoginDTO> token(String account, String password) {
        String url = this.authorityConfig.getUri() + "/api/authority/anno/externalLogin";
        HashMap<String, Object> requestParam = new HashMap<String, Object>();
        requestParam.put("account", account);
        requestParam.put("password", password);
        String authResponse = this.authTemplate.getFormHttpApiService().doPost(url, requestParam);
        JSONObject jsonObject = JSONUtil.parseObj((String)authResponse);
        if (jsonObject.getInt((Object)"code") == 0) {
            LoginDTO loginDTO = (LoginDTO)JSONUtil.toBean((String)jsonObject.getStr((Object)"data"), LoginDTO.class);
            return Result.success(loginDTO);
        }
        return Result.fail(jsonObject.getStr((Object)"msg"));
    }
}

