/*
 * Decompiled with CFR 0.152.
 */
package com.itheima.auth.sdk.common;

public class Result<T> {
    private int code;
    private T data;
    private String msg;

    public static Result timeout() {
        Result result = new Result();
        result.setCode(-1);
        result.setMsg("\u8d85\u65f6");
        return result;
    }

    public static <T> Result success(T data) {
        Result<T> result = new Result<T>();
        result.setCode(0);
        result.setMsg("success");
        result.setData(data);
        return result;
    }

    public static Result success() {
        Result result = new Result();
        result.setCode(0);
        result.setMsg("success");
        return result;
    }

    public static <T> Result fail(String message) {
        Result<T> result = new Result<T>();
        result.setCode(-1);
        result.setMsg(message);
        return result;
    }

    public int getCode() {
        return this.code;
    }

    public void setCode(int code) {
        this.code = code;
    }

    public T getData() {
        return this.data;
    }

    public void setData(T data) {
        this.data = data;
    }

    public String getMsg() {
        return this.msg;
    }

    public void setMsg(String msg) {
        this.msg = msg;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("Result{");
        sb.append("code=").append(this.code);
        sb.append(", data=").append(this.data);
        sb.append(", msg='").append(this.msg).append('\'');
        sb.append('}');
        return sb.toString();
    }
}

