/*
 * Decompiled with CFR 0.152.
 */
package com.itheima.auth.sdk;

import com.itheima.auth.sdk.config.AuthorityConfig;
import com.itheima.auth.sdk.ops.LoginOperations;
import com.itheima.auth.sdk.ops.OrgOperations;
import com.itheima.auth.sdk.ops.PermissionOperations;
import com.itheima.auth.sdk.ops.RoleOperations;
import com.itheima.auth.sdk.ops.UserOperations;
import com.itheima.auth.sdk.ops.impl.LoginOperationsImpl;
import com.itheima.auth.sdk.ops.impl.OrgOperationsImpl;
import com.itheima.auth.sdk.ops.impl.PermissionOperationsImpl;
import com.itheima.auth.sdk.ops.impl.RoleOperationsImpl;
import com.itheima.auth.sdk.ops.impl.UserOperationsImpl;
import com.itheima.auth.sdk.service.FormHttpApiService;
import com.itheima.auth.sdk.service.JsonHttpApiService;

public class AuthTemplate {
    private AuthorityConfig authorityConfig;
    private FormHttpApiService formHttpApiService;
    private JsonHttpApiService jsonHttpApiService;
    private LoginOperations loginOperations;
    private PermissionOperations permissionOperations;
    private OrgOperations orgOperations;
    private RoleOperations roleOperations;
    private UserOperations userOperations;

    public AuthTemplate(String host, int port, int timeout) {
        this(host, port, timeout, null, null);
    }

    public AuthTemplate(String host, int port, int timeout, String token, Long applicationId) {
        this.authorityConfig = new AuthorityConfig(host, port, timeout, token, applicationId);
        this.formHttpApiService = new FormHttpApiService(this.authorityConfig);
        this.jsonHttpApiService = new JsonHttpApiService(this.authorityConfig);
        this.loginOperations = new LoginOperationsImpl(this);
        this.permissionOperations = new PermissionOperationsImpl(this);
        this.orgOperations = new OrgOperationsImpl(this);
        this.roleOperations = new RoleOperationsImpl(this);
        this.userOperations = new UserOperationsImpl(this);
    }

    public AuthTemplate(String host, int port) {
        this(host, port, 10000);
    }

    public LoginOperations opsForLogin() {
        return this.loginOperations;
    }

    public PermissionOperations opsForPermission() {
        return this.permissionOperations;
    }

    public OrgOperations opsForOrg() {
        return this.orgOperations;
    }

    public RoleOperations opsForRole() {
        return this.roleOperations;
    }

    public UserOperations opsForUser() {
        return this.userOperations;
    }

    public AuthorityConfig getAuthorityConfig() {
        return this.authorityConfig;
    }

    public FormHttpApiService getFormHttpApiService() {
        return this.formHttpApiService;
    }

    public JsonHttpApiService getJsonHttpApiService() {
        return this.jsonHttpApiService;
    }
}

