/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.svg.css.impl;

import com.itextpdf.svg.css.impl.StyleResolverUtil;
import com.itextpdf.svg.renderers.ISvgNodeRenderer;
import com.itextpdf.svg.renderers.impl.AbstractBranchSvgNodeRenderer;
import java.util.HashMap;
import java.util.Map;

public class SvgNodeRendererInheritanceResolver {
    private StyleResolverUtil sru = new StyleResolverUtil();

    public void applyInheritanceToSubTree(ISvgNodeRenderer root, ISvgNodeRenderer subTree) {
        this.applyStyles(root, subTree);
        if (subTree instanceof AbstractBranchSvgNodeRenderer) {
            AbstractBranchSvgNodeRenderer subTreeAsBranch = (AbstractBranchSvgNodeRenderer)subTree;
            for (ISvgNodeRenderer child : subTreeAsBranch.getChildren()) {
                this.applyInheritanceToSubTree(subTreeAsBranch, child);
            }
        }
    }

    protected void applyStyles(ISvgNodeRenderer parent, ISvgNodeRenderer child) {
        if (parent != null && child != null) {
            Map<String, String> childStyles = child.getAttributeMapCopy();
            if (childStyles == null) {
                childStyles = new HashMap<String, String>();
            }
            Map<String, String> parentStyles = parent.getAttributeMapCopy();
            String parentFontSize = parent.getAttribute("font-size");
            if (parentFontSize == null) {
                parentFontSize = "0";
            }
            for (Map.Entry<String, String> parentAttribute : parentStyles.entrySet()) {
                this.sru.mergeParentStyleDeclaration(childStyles, parentAttribute.getKey(), parentAttribute.getValue(), parentFontSize);
            }
            child.setAttributesAndStyles(childStyles);
        }
    }
}

