/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.styledxmlparser.css.resolve.shorthand.impl;

import com.itextpdf.io.util.MessageFormatUtil;
import com.itextpdf.styledxmlparser.css.CssDeclaration;
import com.itextpdf.styledxmlparser.css.resolve.CssDefaults;
import com.itextpdf.styledxmlparser.css.resolve.shorthand.IShorthandResolver;
import com.itextpdf.styledxmlparser.css.util.CssTypesValidationUtils;
import com.itextpdf.styledxmlparser.css.validate.CssDeclarationValidationMaster;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FlexShorthandResolver
implements IShorthandResolver {
    private static final Logger LOGGER = LoggerFactory.getLogger(FlexShorthandResolver.class);

    @Override
    public List<CssDeclaration> resolveShorthand(String shorthandExpression) {
        List<CssDeclaration> resolvedProperties;
        if (CssTypesValidationUtils.isInitialOrInheritOrUnset(shorthandExpression = shorthandExpression.trim())) {
            return Arrays.asList(new CssDeclaration("flex-grow", shorthandExpression), new CssDeclaration("flex-shrink", shorthandExpression), new CssDeclaration("flex-basis", shorthandExpression));
        }
        if ("auto".equals(shorthandExpression)) {
            return Arrays.asList(new CssDeclaration("flex-grow", "1"), new CssDeclaration("flex-shrink", "1"), new CssDeclaration("flex-basis", "auto"));
        }
        if ("none".equals(shorthandExpression)) {
            return Arrays.asList(new CssDeclaration("flex-grow", "0"), new CssDeclaration("flex-shrink", "0"), new CssDeclaration("flex-basis", "auto"));
        }
        if (CssTypesValidationUtils.containsInitialOrInheritOrUnset(shorthandExpression)) {
            return FlexShorthandResolver.handleExpressionError("Invalid css property declaration: {0}", "flex", shorthandExpression);
        }
        if (shorthandExpression.isEmpty()) {
            return FlexShorthandResolver.handleExpressionError("{0} shorthand property cannot be empty.", "flex", shorthandExpression);
        }
        String[] flexProps = shorthandExpression.split(" ");
        switch (flexProps.length) {
            case 1: {
                resolvedProperties = this.resolveShorthandWithOneValue(flexProps[0]);
                break;
            }
            case 2: {
                resolvedProperties = this.resolveShorthandWithTwoValues(flexProps[0], flexProps[1]);
                break;
            }
            case 3: {
                resolvedProperties = this.resolveShorthandWithThreeValues(flexProps[0], flexProps[1], flexProps[2]);
                break;
            }
            default: {
                return FlexShorthandResolver.handleExpressionError("Invalid css property declaration: {0}", "flex", shorthandExpression);
            }
        }
        if (!resolvedProperties.isEmpty()) {
            this.fillUnresolvedPropertiesWithDefaultValues(resolvedProperties);
        }
        return resolvedProperties;
    }

    private List<CssDeclaration> resolveShorthandWithOneValue(String firstProperty) {
        ArrayList<CssDeclaration> resolvedProperties = new ArrayList<CssDeclaration>();
        CssDeclaration flexGrowDeclaration = new CssDeclaration("flex-grow", firstProperty);
        if (CssDeclarationValidationMaster.checkDeclaration(flexGrowDeclaration)) {
            resolvedProperties.add(flexGrowDeclaration);
            return resolvedProperties;
        }
        CssDeclaration flexBasisDeclaration = new CssDeclaration("flex-basis", firstProperty);
        if (CssDeclarationValidationMaster.checkDeclaration(flexBasisDeclaration)) {
            resolvedProperties.add(flexBasisDeclaration);
            return resolvedProperties;
        }
        return FlexShorthandResolver.handleExpressionError("Invalid css property declaration: {0}", "flex-grow", firstProperty);
    }

    private List<CssDeclaration> resolveShorthandWithTwoValues(String firstProperty, String secondProperty) {
        ArrayList<CssDeclaration> resolvedProperties = new ArrayList<CssDeclaration>();
        CssDeclaration flexGrowDeclaration = new CssDeclaration("flex-grow", firstProperty);
        if (CssDeclarationValidationMaster.checkDeclaration(flexGrowDeclaration)) {
            resolvedProperties.add(flexGrowDeclaration);
            CssDeclaration flexShrinkDeclaration = new CssDeclaration("flex-shrink", secondProperty);
            if (CssDeclarationValidationMaster.checkDeclaration(flexShrinkDeclaration)) {
                resolvedProperties.add(flexShrinkDeclaration);
                return resolvedProperties;
            }
            CssDeclaration flexBasisDeclaration = new CssDeclaration("flex-basis", secondProperty);
            if (CssDeclarationValidationMaster.checkDeclaration(flexBasisDeclaration)) {
                resolvedProperties.add(flexBasisDeclaration);
                return resolvedProperties;
            }
            return FlexShorthandResolver.handleExpressionError("Invalid css property declaration: {0}", "flex-basis", secondProperty);
        }
        CssDeclaration flexBasisDeclaration = new CssDeclaration("flex-basis", firstProperty);
        if (CssDeclarationValidationMaster.checkDeclaration(flexBasisDeclaration)) {
            resolvedProperties.add(flexBasisDeclaration);
            flexGrowDeclaration.setExpression(secondProperty);
            if (CssDeclarationValidationMaster.checkDeclaration(flexGrowDeclaration)) {
                resolvedProperties.add(flexGrowDeclaration);
                return resolvedProperties;
            }
            return FlexShorthandResolver.handleExpressionError("Invalid css property declaration: {0}", "flex-grow", secondProperty);
        }
        return FlexShorthandResolver.handleExpressionError("Invalid css property declaration: {0}", "flex-shrink", secondProperty);
    }

    private List<CssDeclaration> resolveShorthandWithThreeValues(String firstProperty, String secondProperty, String thirdProperty) {
        ArrayList<CssDeclaration> resolvedProperties = new ArrayList<CssDeclaration>();
        CssDeclaration flexGrowDeclaration = new CssDeclaration("flex-grow", firstProperty);
        if (CssDeclarationValidationMaster.checkDeclaration(flexGrowDeclaration)) {
            resolvedProperties.add(flexGrowDeclaration);
            CssDeclaration flexShrinkDeclaration = new CssDeclaration("flex-shrink", secondProperty);
            if (!CssDeclarationValidationMaster.checkDeclaration(flexShrinkDeclaration)) {
                return FlexShorthandResolver.handleExpressionError("Invalid css property declaration: {0}", "flex-shrink", secondProperty);
            }
            resolvedProperties.add(flexShrinkDeclaration);
            CssDeclaration flexBasisDeclaration = new CssDeclaration("flex-basis", thirdProperty);
            if (!CssDeclarationValidationMaster.checkDeclaration(flexBasisDeclaration)) {
                return FlexShorthandResolver.handleExpressionError("Invalid css property declaration: {0}", "flex-basis", thirdProperty);
            }
            resolvedProperties.add(flexBasisDeclaration);
            return resolvedProperties;
        }
        flexGrowDeclaration = new CssDeclaration("flex-grow", secondProperty);
        if (CssDeclarationValidationMaster.checkDeclaration(flexGrowDeclaration)) {
            resolvedProperties.add(flexGrowDeclaration);
            CssDeclaration flexShrinkDeclaration = new CssDeclaration("flex-shrink", thirdProperty);
            if (!CssDeclarationValidationMaster.checkDeclaration(flexShrinkDeclaration)) {
                return FlexShorthandResolver.handleExpressionError("Invalid css property declaration: {0}", "flex-shrink", thirdProperty);
            }
            resolvedProperties.add(flexShrinkDeclaration);
            CssDeclaration flexBasisDeclaration = new CssDeclaration("flex-basis", firstProperty);
            if (!CssDeclarationValidationMaster.checkDeclaration(flexBasisDeclaration)) {
                return FlexShorthandResolver.handleExpressionError("Invalid css property declaration: {0}", "flex-basis", firstProperty);
            }
            resolvedProperties.add(flexBasisDeclaration);
            return resolvedProperties;
        }
        return FlexShorthandResolver.handleExpressionError("Invalid css property declaration: {0}", "flex-grow", secondProperty);
    }

    private void fillUnresolvedPropertiesWithDefaultValues(List<CssDeclaration> resolvedProperties) {
        if (!resolvedProperties.stream().anyMatch(property -> property.getProperty().equals("flex-grow"))) {
            resolvedProperties.add(new CssDeclaration("flex-grow", CssDefaults.getDefaultValue("flex-grow")));
        }
        if (!resolvedProperties.stream().anyMatch(property -> property.getProperty().equals("flex-shrink"))) {
            resolvedProperties.add(new CssDeclaration("flex-shrink", CssDefaults.getDefaultValue("flex-shrink")));
        }
        if (!resolvedProperties.stream().anyMatch(property -> property.getProperty().equals("flex-basis"))) {
            resolvedProperties.add(new CssDeclaration("flex-basis", "0"));
        }
    }

    private static List<CssDeclaration> handleExpressionError(String logMessage, String attribute, String shorthandExpression) {
        LOGGER.warn(MessageFormatUtil.format((String)logMessage, (Object[])new Object[]{attribute, shorthandExpression}));
        return Collections.emptyList();
    }
}

