/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.styledxmlparser.css.util;

import com.itextpdf.layout.font.Range;
import com.itextpdf.layout.font.RangeBuilder;
import com.itextpdf.layout.property.BlendMode;
import com.itextpdf.layout.property.UnitValue;
import com.itextpdf.styledxmlparser.css.parse.CssDeclarationValueTokenizer;
import com.itextpdf.styledxmlparser.css.util.CssDimensionParsingUtils;
import com.itextpdf.styledxmlparser.css.util.CssPropertyNormalizer;
import com.itextpdf.styledxmlparser.css.util.CssTypesValidationUtils;
import com.itextpdf.styledxmlparser.css.util.EscapeGroup;
import com.itextpdf.styledxmlparser.node.IElementNode;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CssUtils {
    @Deprecated
    private static final String[] FONT_RELATIVE_MEASUREMENTS_VALUES = new String[]{"em", "ex", "rem"};
    private static final float EPSILON = 1.0E-6f;
    private static final Logger logger = LoggerFactory.getLogger(CssUtils.class);

    private CssUtils() {
    }

    public static List<String> splitStringWithComma(String value) {
        return CssUtils.splitString(value, ',', new EscapeGroup('(', ')'));
    }

    public static List<String> splitString(String value, char splitChar, EscapeGroup ... escapeCharacters) {
        if (value == null) {
            return new ArrayList<String>();
        }
        ArrayList<String> resultList = new ArrayList<String>();
        int lastSplitChar = 0;
        for (int i = 0; i < value.length(); ++i) {
            char currentChar = value.charAt(i);
            boolean isEscaped = false;
            for (EscapeGroup character : escapeCharacters) {
                if (currentChar == splitChar) {
                    isEscaped = isEscaped || character.isEscaped();
                    continue;
                }
                character.processCharacter(currentChar);
            }
            if (currentChar != splitChar || isEscaped) continue;
            resultList.add(value.substring(lastSplitChar, i));
            lastSplitChar = i + 1;
        }
        String lastToken = value.substring(lastSplitChar);
        if (!lastToken.isEmpty()) {
            resultList.add(lastToken);
        }
        return resultList;
    }

    public static BlendMode parseBlendMode(String cssValue) {
        if (cssValue == null) {
            return BlendMode.NORMAL;
        }
        switch (cssValue) {
            case "multiply": {
                return BlendMode.MULTIPLY;
            }
            case "screen": {
                return BlendMode.SCREEN;
            }
            case "overlay": {
                return BlendMode.OVERLAY;
            }
            case "darken": {
                return BlendMode.DARKEN;
            }
            case "lighten": {
                return BlendMode.LIGHTEN;
            }
            case "color-dodge": {
                return BlendMode.COLOR_DODGE;
            }
            case "color-burn": {
                return BlendMode.COLOR_BURN;
            }
            case "hard-light": {
                return BlendMode.HARD_LIGHT;
            }
            case "soft-light": {
                return BlendMode.SOFT_LIGHT;
            }
            case "difference": {
                return BlendMode.DIFFERENCE;
            }
            case "exclusion": {
                return BlendMode.EXCLUSION;
            }
            case "hue": {
                return BlendMode.HUE;
            }
            case "saturation": {
                return BlendMode.SATURATION;
            }
            case "color": {
                return BlendMode.COLOR;
            }
            case "luminosity": {
                return BlendMode.LUMINOSITY;
            }
        }
        return BlendMode.NORMAL;
    }

    public static List<List<String>> extractShorthandProperties(String str) {
        ArrayList<List<String>> result = new ArrayList<List<String>>();
        ArrayList<String> currentLayer = new ArrayList<String>();
        CssDeclarationValueTokenizer tokenizer = new CssDeclarationValueTokenizer(str);
        CssDeclarationValueTokenizer.Token currentToken = tokenizer.getNextValidToken();
        while (currentToken != null) {
            if (currentToken.getType() == CssDeclarationValueTokenizer.TokenType.COMMA) {
                result.add(currentLayer);
                currentLayer = new ArrayList();
            } else {
                currentLayer.add(currentToken.getValue());
            }
            currentToken = tokenizer.getNextValidToken();
        }
        result.add(currentLayer);
        return result;
    }

    public static String normalizeCssProperty(String str) {
        return str == null ? null : CssPropertyNormalizer.normalize(str);
    }

    public static String removeDoubleSpacesAndTrim(String str) {
        String[] parts = str.split("\\s");
        StringBuilder sb = new StringBuilder();
        for (String part : parts) {
            if (part.length() <= 0) continue;
            if (sb.length() != 0) {
                sb.append(" ");
            }
            sb.append(part);
        }
        return sb.toString();
    }

    @Deprecated
    public static Integer parseInteger(String str) {
        return CssDimensionParsingUtils.parseInteger(str);
    }

    @Deprecated
    public static Float parseFloat(String str) {
        return CssDimensionParsingUtils.parseFloat(str);
    }

    @Deprecated
    public static Double parseDouble(String str) {
        return CssDimensionParsingUtils.parseDouble(str);
    }

    @Deprecated
    public static float parseAngle(String angle, String defaultMetric) {
        return CssDimensionParsingUtils.parseAngle(angle, defaultMetric);
    }

    @Deprecated
    public static float parseAngle(String angle) {
        return CssDimensionParsingUtils.parseAngle(angle);
    }

    @Deprecated
    public static int[] parseAspectRatio(String str) {
        return CssDimensionParsingUtils.parseAspectRatio(str);
    }

    @Deprecated
    public static float parseAbsoluteLength(String length, String defaultMetric) {
        return CssDimensionParsingUtils.parseAbsoluteLength(length, defaultMetric);
    }

    @Deprecated
    public static float parseAbsoluteLength(String length) {
        return CssDimensionParsingUtils.parseAbsoluteLength(length);
    }

    @Deprecated
    public static float parseRelativeValue(String relativeValue, float baseValue) {
        return CssDimensionParsingUtils.parseRelativeValue(relativeValue, baseValue);
    }

    @Deprecated
    public static UnitValue parseLengthValueToPt(String value, float emValue, float remValue) {
        return CssDimensionParsingUtils.parseLengthValueToPt(value, emValue, remValue);
    }

    @Deprecated
    public static boolean isValidNumericValue(String value) {
        return CssTypesValidationUtils.isValidNumericValue(value);
    }

    @Deprecated
    public static float parseAbsoluteFontSize(String fontSizeValue, String defaultMetric) {
        return CssDimensionParsingUtils.parseAbsoluteFontSize(fontSizeValue, defaultMetric);
    }

    @Deprecated
    public static float parseAbsoluteFontSize(String fontSizeValue) {
        return CssDimensionParsingUtils.parseAbsoluteFontSize(fontSizeValue);
    }

    @Deprecated
    public static float parseRelativeFontSize(String relativeFontSizeValue, float baseValue) {
        return CssDimensionParsingUtils.parseRelativeFontSize(relativeFontSizeValue, baseValue);
    }

    @Deprecated
    public static UnitValue[] parseSpecificCornerBorderRadius(String specificBorderRadius, float emValue, float remValue) {
        return CssDimensionParsingUtils.parseSpecificCornerBorderRadius(specificBorderRadius, emValue, remValue);
    }

    @Deprecated
    public static float parseResolution(String resolutionStr) {
        return CssDimensionParsingUtils.parseResolution(resolutionStr);
    }

    @Deprecated
    public static int determinePositionBetweenValueAndUnit(String string) {
        return CssDimensionParsingUtils.determinePositionBetweenValueAndUnit(string);
    }

    @Deprecated
    public static boolean isMetricValue(String value) {
        return CssTypesValidationUtils.isMetricValue(value);
    }

    @Deprecated
    public static boolean isAngleValue(String value) {
        return CssTypesValidationUtils.isAngleValue(value);
    }

    @Deprecated
    public static boolean isRelativeValue(String value) {
        return CssTypesValidationUtils.isRelativeValue(value);
    }

    @Deprecated
    public static boolean isFontRelativeValue(String value) {
        if (value == null) {
            return false;
        }
        for (String relativePostfix : FONT_RELATIVE_MEASUREMENTS_VALUES) {
            if (!value.endsWith(relativePostfix) || !CssTypesValidationUtils.isNumericValue(value.substring(0, value.length() - relativePostfix.length()).trim())) continue;
            return true;
        }
        return false;
    }

    @Deprecated
    public static boolean isPercentageValue(String value) {
        return CssTypesValidationUtils.isPercentageValue(value);
    }

    @Deprecated
    public static boolean isRemValue(String value) {
        return CssTypesValidationUtils.isRemValue(value);
    }

    @Deprecated
    public static boolean isEmValue(String value) {
        return CssTypesValidationUtils.isEmValue(value);
    }

    @Deprecated
    public static boolean isExValue(String value) {
        return CssTypesValidationUtils.isExValue(value);
    }

    @Deprecated
    public static boolean isNumericValue(String value) {
        return CssTypesValidationUtils.isNumericValue(value);
    }

    @Deprecated
    public static boolean isNegativeValue(String value) {
        return CssTypesValidationUtils.isNegativeValue(value);
    }

    public static String extractUrl(String url) {
        String urlString;
        String str = null;
        str = url.startsWith("url") ? ((urlString = url.substring(3).trim().replace("(", "").replace(")", "").trim()).startsWith("'") && urlString.endsWith("'") ? urlString.substring(urlString.indexOf("'") + 1, urlString.lastIndexOf("'")) : (urlString.startsWith("\"") && urlString.endsWith("\"") ? urlString.substring(urlString.indexOf(34) + 1, urlString.lastIndexOf(34)) : urlString)) : url;
        return str;
    }

    @Deprecated
    public static boolean isBase64Data(String data) {
        return CssTypesValidationUtils.isBase64Data(data);
    }

    public static int findNextUnescapedChar(String source, char ch, int startIndex) {
        int afterNoneEscapePos;
        int symbolPos = source.indexOf(ch, startIndex);
        if (symbolPos == -1) {
            return -1;
        }
        for (afterNoneEscapePos = symbolPos; afterNoneEscapePos > 0 && source.charAt(afterNoneEscapePos - 1) == '\\'; --afterNoneEscapePos) {
        }
        return (symbolPos - afterNoneEscapePos) % 2 == 0 ? symbolPos : CssUtils.findNextUnescapedChar(source, ch, symbolPos + 1);
    }

    @Deprecated
    public static boolean isColorProperty(String value) {
        return CssTypesValidationUtils.isColorProperty(value);
    }

    public static boolean compareFloats(double d1, double d2) {
        return Math.abs(d1 - d2) < (double)1.0E-6f;
    }

    public static boolean compareFloats(float f1, float f2) {
        return Math.abs(f1 - f2) < 1.0E-6f;
    }

    @Deprecated
    public static float[] parseRgbaColor(String colorValue) {
        return CssDimensionParsingUtils.parseRgbaColor(colorValue);
    }

    public static Range parseUnicodeRange(String unicodeRange) {
        String[] ranges = unicodeRange.split(",");
        RangeBuilder builder = new RangeBuilder();
        for (String range : ranges) {
            if (CssUtils.addRange(builder, range)) continue;
            return null;
        }
        return builder.create();
    }

    public static float convertPtsToPx(float pts) {
        return pts / 0.75f;
    }

    public static double convertPtsToPx(double pts) {
        return pts / 0.75;
    }

    public static float convertPxToPts(float px) {
        return px * 0.75f;
    }

    public static double convertPxToPts(double px) {
        return px * 0.75;
    }

    public static boolean isStyleSheetLink(IElementNode headChildElement) {
        return "link".equals(headChildElement.name()) && "stylesheet".equals(headChildElement.getAttribute("rel"));
    }

    @Deprecated
    public static boolean isInitialOrInheritOrUnset(String value) {
        return CssTypesValidationUtils.isInitialOrInheritOrUnset(value);
    }

    private static boolean addRange(RangeBuilder builder, String range) {
        if ((range = range.trim()).matches("[uU]\\+[0-9a-fA-F?]{1,6}(-[0-9a-fA-F]{1,6})?")) {
            String[] parts = range.substring(2, range.length()).split("-");
            if (1 == parts.length) {
                if (parts[0].contains("?")) {
                    return CssUtils.addRange(builder, parts[0].replace('?', '0'), parts[0].replace('?', 'F'));
                }
                return CssUtils.addRange(builder, parts[0], parts[0]);
            }
            return CssUtils.addRange(builder, parts[0], parts[1]);
        }
        return false;
    }

    private static boolean addRange(RangeBuilder builder, String left, String right) {
        int r;
        int l = Integer.parseInt(left, 16);
        if (l > (r = Integer.parseInt(right, 16)) || r > 0x10FFFF) {
            return false;
        }
        builder.addRange(l, r);
        return true;
    }
}

