/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.styledxmlparser.css.resolve.shorthand.impl;

import com.itextpdf.styledxmlparser.css.CssDeclaration;
import com.itextpdf.styledxmlparser.css.resolve.shorthand.IShorthandResolver;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class TextDecorationShorthandResolver
implements IShorthandResolver {
    private static final Set<String> TEXT_DECORATION_LINE_VALUES = new HashSet<String>(Arrays.asList("underline", "overline", "line-through", "blink"));
    private static final Set<String> TEXT_DECORATION_STYLE_VALUES = new HashSet<String>(Arrays.asList("solid", "double", "dotted", "dashed", "wavy"));

    @Override
    public List<CssDeclaration> resolveShorthand(String shorthandExpression) {
        if ("initial".equals(shorthandExpression) || "inherit".equals(shorthandExpression)) {
            return Arrays.asList(new CssDeclaration("text-decoration-line", shorthandExpression), new CssDeclaration("text-decoration-style", shorthandExpression), new CssDeclaration("text-decoration-color", shorthandExpression));
        }
        String[] props = shorthandExpression.split("\\s+(?![^\\(]*\\))");
        ArrayList<String> textDecorationLineValues = new ArrayList<String>();
        String textDecorationStyleValue = null;
        String textDecorationColorValue = null;
        for (String value : props) {
            if (TEXT_DECORATION_LINE_VALUES.contains(value) || "none".equals(value)) {
                textDecorationLineValues.add(value);
                continue;
            }
            if (TEXT_DECORATION_STYLE_VALUES.contains(value)) {
                textDecorationStyleValue = value;
                continue;
            }
            if (value.isEmpty()) continue;
            textDecorationColorValue = value;
        }
        ArrayList<CssDeclaration> resolvedDecl = new ArrayList<CssDeclaration>();
        if (textDecorationLineValues.isEmpty()) {
            resolvedDecl.add(new CssDeclaration("text-decoration-line", "initial"));
        } else {
            StringBuilder resultLine = new StringBuilder();
            for (String line : textDecorationLineValues) {
                resultLine.append(line).append(" ");
            }
            resolvedDecl.add(new CssDeclaration("text-decoration-line", resultLine.toString().trim()));
        }
        resolvedDecl.add(new CssDeclaration("text-decoration-style", textDecorationStyleValue == null ? "initial" : textDecorationStyleValue));
        resolvedDecl.add(new CssDeclaration("text-decoration-color", textDecorationColorValue == null ? "initial" : textDecorationColorValue));
        return resolvedDecl;
    }
}

