/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.styledxmlparser.css.media;

import com.itextpdf.styledxmlparser.css.media.MediaExpression;
import com.itextpdf.styledxmlparser.css.media.MediaQuery;
import com.itextpdf.styledxmlparser.css.media.MediaType;
import java.util.ArrayList;
import java.util.List;

public final class MediaQueryParser {
    private MediaQueryParser() {
    }

    static List<MediaQuery> parseMediaQueries(String mediaQueriesStr) {
        String[] mediaQueryStrs = mediaQueriesStr.split(",");
        ArrayList<MediaQuery> mediaQueries = new ArrayList<MediaQuery>();
        for (String mediaQueryStr : mediaQueryStrs) {
            MediaQuery mediaQuery = MediaQueryParser.parseMediaQuery(mediaQueryStr);
            if (mediaQuery == null) continue;
            mediaQueries.add(mediaQuery);
        }
        return mediaQueries;
    }

    static MediaQuery parseMediaQuery(String mediaQueryStr) {
        mediaQueryStr = mediaQueryStr.trim().toLowerCase();
        boolean only = false;
        boolean not = false;
        if (mediaQueryStr.startsWith("only")) {
            only = true;
            mediaQueryStr = mediaQueryStr.substring("only".length()).trim();
        } else if (mediaQueryStr.startsWith("not")) {
            not = true;
            mediaQueryStr = mediaQueryStr.substring("not".length()).trim();
        }
        int indexOfSpace = mediaQueryStr.indexOf(32);
        String firstWord = indexOfSpace != -1 ? mediaQueryStr.substring(0, indexOfSpace) : mediaQueryStr;
        String mediaType = null;
        List<MediaExpression> mediaExpressions = null;
        if (only || not || MediaType.isValidMediaType(firstWord)) {
            mediaType = firstWord;
            mediaExpressions = MediaQueryParser.parseMediaExpressions(mediaQueryStr.substring(firstWord.length()), true);
        } else {
            mediaExpressions = MediaQueryParser.parseMediaExpressions(mediaQueryStr, false);
        }
        return new MediaQuery(mediaType, mediaExpressions, only, not);
    }

    private static List<MediaExpression> parseMediaExpressions(String mediaExpressionsStr, boolean shallStartWithAnd) {
        mediaExpressionsStr = mediaExpressionsStr.trim();
        boolean startsWithEnd = mediaExpressionsStr.startsWith("and");
        boolean firstExpression = true;
        String[] mediaExpressionStrs = mediaExpressionsStr.split("and");
        ArrayList<MediaExpression> expressions = new ArrayList<MediaExpression>();
        for (String mediaExpressionStr : mediaExpressionStrs) {
            MediaExpression expression = MediaQueryParser.parseMediaExpression(mediaExpressionStr);
            if (expression == null) continue;
            if (firstExpression && shallStartWithAnd && !startsWithEnd) {
                throw new IllegalStateException("Expected 'and' while parsing media expression");
            }
            firstExpression = false;
            expressions.add(expression);
        }
        return expressions;
    }

    private static MediaExpression parseMediaExpression(String mediaExpressionStr) {
        String mediaFeature;
        if (!(mediaExpressionStr = mediaExpressionStr.trim()).startsWith("(") || !mediaExpressionStr.endsWith(")")) {
            return null;
        }
        if ((mediaExpressionStr = mediaExpressionStr.substring(1, mediaExpressionStr.length() - 1)).length() == 0) {
            return null;
        }
        int colonPos = mediaExpressionStr.indexOf(58);
        String value = null;
        if (colonPos == -1) {
            mediaFeature = mediaExpressionStr;
        } else {
            mediaFeature = mediaExpressionStr.substring(0, colonPos).trim();
            value = mediaExpressionStr.substring(colonPos + 1).trim();
        }
        return new MediaExpression(mediaFeature, value);
    }
}

