/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.test.pdfa;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collections;
import java.util.EnumSet;
import org.verapdf.core.VeraPDFException;
import org.verapdf.features.FeatureExtractorConfig;
import org.verapdf.metadata.fixer.MetadataFixerConfig;
import org.verapdf.pdfa.VeraGreenfieldFoundryProvider;
import org.verapdf.pdfa.validation.validators.ValidatorConfig;
import org.verapdf.processor.BatchProcessor;
import org.verapdf.processor.FormatOption;
import org.verapdf.processor.ProcessorConfig;
import org.verapdf.processor.ProcessorFactory;
import org.verapdf.processor.TaskType;
import org.verapdf.processor.plugins.PluginsCollectionConfig;
import org.verapdf.processor.reports.BatchSummary;

public class VeraPdfValidator {
    public String validate(String filePath) {
        String errorMessage = null;
        try {
            File xmlReport = new File(filePath.substring(0, filePath.length() - ".pdf".length()) + ".xml");
            VeraGreenfieldFoundryProvider.initialise();
            ProcessorConfig customProfile = ProcessorFactory.defaultConfig();
            FeatureExtractorConfig featuresConfig = customProfile.getFeatureConfig();
            ValidatorConfig valConfig = customProfile.getValidatorConfig();
            PluginsCollectionConfig plugConfig = customProfile.getPluginsCollectionConfig();
            MetadataFixerConfig metaConfig = customProfile.getFixerConfig();
            ProcessorConfig resultConfig = ProcessorFactory.fromValues((ValidatorConfig)valConfig, (FeatureExtractorConfig)featuresConfig, (PluginsCollectionConfig)plugConfig, (MetadataFixerConfig)metaConfig, EnumSet.of(TaskType.VALIDATE));
            BatchProcessor processor = ProcessorFactory.fileBatchProcessor((ProcessorConfig)resultConfig);
            BatchSummary summary = processor.process(Collections.singletonList(new File(filePath)), ProcessorFactory.getHandler((FormatOption)FormatOption.XML, (boolean)true, (OutputStream)new FileOutputStream(String.valueOf(xmlReport)), (int)125, (boolean)false));
            String xmlReportPath = "file://" + xmlReport.toURI().normalize().getPath();
            if (summary.getFailedParsingJobs() != 0) {
                errorMessage = "An error occurred while parsing current file. See report:  " + xmlReportPath;
            } else if (summary.getFailedEncryptedJobs() != 0) {
                errorMessage = "VeraPDF execution failed - specified file is encrypted. See report:  " + xmlReportPath;
            } else if (summary.getValidationSummary().getNonCompliantPdfaCount() != 0) {
                errorMessage = "VeraPDF verification failed. See verification results:  " + xmlReportPath;
            } else {
                System.out.println("VeraPDF verification finished. See verification report: " + xmlReportPath);
            }
        }
        catch (IOException | VeraPDFException exc) {
            errorMessage = "VeraPDF execution failed:\n" + exc.getMessage();
        }
        return errorMessage;
    }
}

