/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.layout.renderer;

import com.itextpdf.layout.properties.grid.AutoRepeatValue;
import com.itextpdf.layout.properties.grid.FixedRepeatValue;
import com.itextpdf.layout.properties.grid.GridValue;
import com.itextpdf.layout.properties.grid.MinMaxValue;
import com.itextpdf.layout.properties.grid.PercentValue;
import com.itextpdf.layout.properties.grid.PointValue;
import com.itextpdf.layout.properties.grid.TemplateValue;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.LoggerFactory;

class GridTemplateResolver {
    private final float space;
    private final float gap;
    private boolean containsIntrinsicOrFlexible = false;
    private AutoRepeatResolver autoRepeatResolver = null;
    private Result result = new Result(new ArrayList<GridValue>());

    GridTemplateResolver(float space, float gap) {
        this.space = space;
        this.gap = gap;
    }

    boolean isCollapseNullLines() {
        return this.autoRepeatResolver != null && this.autoRepeatResolver.repeat.isAutoFit();
    }

    int getFixedValuesCount() {
        if (this.autoRepeatResolver == null) {
            return this.result.size();
        }
        return this.result.size() - (this.autoRepeatResolver.end - this.autoRepeatResolver.start);
    }

    List<GridValue> shrinkTemplatesToFitSize(int sizeToFit) {
        if (this.autoRepeatResolver == null) {
            return this.result.getList();
        }
        return this.autoRepeatResolver.shrinkTemplatesToFitSize(sizeToFit);
    }

    List<GridValue> resolveTemplate(List<TemplateValue> template) {
        if (template == null) {
            return null;
        }
        try {
            float leftSpace = this.space;
            for (TemplateValue value : template) {
                leftSpace -= this.processValue(value);
                leftSpace -= this.gap;
            }
            leftSpace += this.gap;
            if (this.autoRepeatResolver != null) {
                if (this.autoRepeatResolver.start == this.result.size()) {
                    leftSpace += this.gap;
                }
                this.autoRepeatResolver.resolve(leftSpace);
            }
            return this.result.getList();
        }
        catch (IllegalStateException exception) {
            LoggerFactory.getLogger(GridTemplateResolver.class).warn(exception.getMessage());
            this.reset();
            return null;
        }
    }

    private float processValue(TemplateValue value) {
        switch (value.getType()) {
            case MIN_CONTENT: 
            case MAX_CONTENT: 
            case AUTO: 
            case FLEX: 
            case FIT_CONTENT: {
                this.result.addValue((GridValue)value);
                this.containsIntrinsicOrFlexible = true;
                break;
            }
            case POINT: {
                this.result.addValue((GridValue)value);
                return ((PointValue)value).getValue();
            }
            case PERCENT: {
                this.result.addValue((GridValue)value);
                return this.space > 0.0f ? ((PercentValue)value).getValue() / 100.0f * this.space : 0.0f;
            }
            case MINMAX: {
                this.result.addValue((GridValue)value);
                this.result.setFreeze(true);
                boolean currentValue = this.containsIntrinsicOrFlexible;
                MinMaxValue minMaxValue = (MinMaxValue)value;
                if (minMaxValue.getMin().getType() == TemplateValue.ValueType.FLEX) {
                    throw new IllegalStateException("Flexible values aren't allowed as minimum in minmax grid function.");
                }
                float length = this.processValue(minMaxValue.getMax());
                if (this.containsIntrinsicOrFlexible) {
                    length = this.processValue(minMaxValue.getMin());
                }
                this.containsIntrinsicOrFlexible = currentValue;
                this.result.setFreeze(false);
                return length;
            }
            case FIXED_REPEAT: {
                float usedSpace = 0.0f;
                FixedRepeatValue repeat = (FixedRepeatValue)value;
                for (int i = 0; i < repeat.getRepeatCount(); ++i) {
                    for (GridValue element : repeat.getValues()) {
                        usedSpace += this.processValue(element);
                    }
                    usedSpace += (float)(repeat.getValues().size() - 1) * this.gap;
                }
                return usedSpace;
            }
            case AUTO_REPEAT: {
                if (this.autoRepeatResolver != null) {
                    throw new IllegalStateException("Automatic repetitions in the grid template are allowed only once per template.");
                }
                this.autoRepeatResolver = new AutoRepeatResolver((AutoRepeatValue)value, this.result.size());
            }
        }
        return 0.0f;
    }

    private void reset() {
        this.autoRepeatResolver = null;
        this.result.getList().clear();
        this.result.setInsertPoint(-1);
    }

    private static class Result {
        final List<GridValue> result;
        int insertPoint = -1;
        boolean freeze = false;

        Result(List<GridValue> result) {
            this.result = result;
        }

        public void addValue(GridValue value) {
            if (this.freeze) {
                return;
            }
            if (this.insertPoint < 0) {
                this.result.add(value);
            } else {
                this.result.add(this.insertPoint++, value);
            }
        }

        public void setInsertPoint(int insertPoint) {
            this.insertPoint = insertPoint;
        }

        public int size() {
            return this.result.size();
        }

        public List<GridValue> getList() {
            return this.result;
        }

        public void setFreeze(boolean freeze) {
            this.freeze = freeze;
        }
    }

    private class AutoRepeatResolver {
        final AutoRepeatValue repeat;
        final int start;
        int end = -1;

        AutoRepeatResolver(AutoRepeatValue repeat, int pos) {
            this.repeat = repeat;
            this.start = pos;
        }

        public void resolve(float leftSpace) {
            float usedSpace = 0.0f;
            float usedSpacePerIteration = -1.0f;
            int fixedTemplatesCount = GridTemplateResolver.this.result.size();
            do {
                GridTemplateResolver.this.result.setInsertPoint(this.start);
                for (GridValue value : this.repeat.getValues()) {
                    usedSpace += GridTemplateResolver.this.processValue(value);
                    usedSpace += GridTemplateResolver.this.gap;
                }
                if (usedSpacePerIteration < 0.0f) {
                    usedSpacePerIteration = usedSpace;
                }
                if (!GridTemplateResolver.this.containsIntrinsicOrFlexible) continue;
                throw new IllegalStateException("Automatic repetitions in the grid template cannot be combined with intrinsic or flexible sizes.");
            } while (usedSpace + usedSpacePerIteration <= leftSpace);
            this.end = this.start + GridTemplateResolver.this.result.size() - fixedTemplatesCount;
        }

        List<GridValue> shrinkTemplatesToFitSize(int sizeToFit) {
            int i;
            int allowedRepeatValuesCount = this.getAllowedRepeatValuesCount(sizeToFit);
            ArrayList<GridValue> shrankResult = new ArrayList<GridValue>(GridTemplateResolver.this.result.size());
            List<GridValue> previousResult = GridTemplateResolver.this.result.getList();
            for (i = 0; i < this.start; ++i) {
                shrankResult.add(previousResult.get(i));
            }
            for (i = 0; i < allowedRepeatValuesCount; ++i) {
                shrankResult.addAll(this.repeat.getValues());
            }
            for (i = this.end; i < previousResult.size(); ++i) {
                shrankResult.add(previousResult.get(i));
            }
            GridTemplateResolver.this.result = new Result(shrankResult);
            return GridTemplateResolver.this.result.getList();
        }

        private int getAllowedRepeatValuesCount(int sizeToFit) {
            int allowedRepeatValuesCount = Math.min(sizeToFit - GridTemplateResolver.this.getFixedValuesCount(), this.end - this.start) / this.repeat.getValues().size() * this.repeat.getValues().size();
            if (GridTemplateResolver.this.space < 0.0f && allowedRepeatValuesCount > 0) {
                allowedRepeatValuesCount = 1;
            }
            return allowedRepeatValuesCount;
        }
    }
}

