/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.layout.hyphenation;

import com.itextpdf.commons.utils.FileUtil;
import com.itextpdf.io.util.ResourceUtil;
import com.itextpdf.layout.hyphenation.Hyphenation;
import com.itextpdf.layout.hyphenation.HyphenationException;
import com.itextpdf.layout.hyphenation.HyphenationTree;
import com.itextpdf.layout.hyphenation.HyphenationTreeCache;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Hyphenator {
    private static final char SOFT_HYPHEN = '\u00ad';
    private static final Object staticLock = new Object();
    private static Logger log = LoggerFactory.getLogger(Hyphenator.class);
    private static HyphenationTreeCache hTreeCache;
    private static List<String> additionalHyphenationFileDirectories;
    protected String lang;
    protected String country;
    int leftMin;
    int rightMin;
    Map<String, String> hyphPathNames;

    public Hyphenator(String lang, String country, int leftMin, int rightMin) {
        this.lang = lang;
        this.country = country;
        this.leftMin = leftMin;
        this.rightMin = rightMin;
    }

    public Hyphenator(String lang, String country, int leftMin, int rightMin, Map<String, String> hyphPathNames) {
        this(lang, country, leftMin, rightMin);
        this.hyphPathNames = hyphPathNames;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerAdditionalHyphenationFileDirectory(String directory) {
        Object object = staticLock;
        synchronized (object) {
            if (additionalHyphenationFileDirectories == null) {
                additionalHyphenationFileDirectories = new ArrayList<String>();
            }
            additionalHyphenationFileDirectories.add(directory);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HyphenationTreeCache getHyphenationTreeCache() {
        Object object = staticLock;
        synchronized (object) {
            if (hTreeCache == null) {
                hTreeCache = new HyphenationTreeCache();
            }
        }
        return hTreeCache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearHyphenationTreeCache() {
        Object object = staticLock;
        synchronized (object) {
            hTreeCache = new HyphenationTreeCache();
        }
    }

    public static HyphenationTree getHyphenationTree(String lang, String country, Map<String, String> hyphPathNames) {
        String llKey;
        String llccKey = HyphenationTreeCache.constructLlccKey(lang, country);
        HyphenationTreeCache cache = Hyphenator.getHyphenationTreeCache();
        if (cache.isMissing(llccKey)) {
            return null;
        }
        HyphenationTree hTree = Hyphenator.getHyphenationTree2(lang, country, hyphPathNames);
        if (hTree == null && country != null && !country.equals("none") && !cache.isMissing(llKey = HyphenationTreeCache.constructLlccKey(lang, null))) {
            hTree = Hyphenator.getHyphenationTree2(lang, null, hyphPathNames);
            if (hTree != null && log.isDebugEnabled()) {
                log.debug("Couldn't find hyphenation pattern for lang=\"" + lang + "\",country=\"" + country + "\". Using general language pattern for lang=\"" + lang + "\" instead.");
            }
            if (hTree == null) {
                cache.noteMissing(llKey);
            } else {
                cache.cache(llccKey, hTree);
            }
        }
        if (hTree == null) {
            cache.noteMissing(llccKey);
            log.error("Couldn't find hyphenation pattern for lang=\"" + lang + "\"" + (country != null && !country.equals("none") ? ",country=\"" + country + "\"" : "") + ".");
        }
        return hTree;
    }

    public static HyphenationTree getHyphenationTree2(String lang, String country, Map<String, String> hyphPathNames) {
        InputStream defaultHyphenationResourceStream;
        String llccKey = HyphenationTreeCache.constructLlccKey(lang, country);
        HyphenationTreeCache cache = Hyphenator.getHyphenationTreeCache();
        HyphenationTree hTree = Hyphenator.getHyphenationTreeCache().getHyphenationTree(lang, country);
        if (hTree != null) {
            return hTree;
        }
        String key = HyphenationTreeCache.constructUserKey(lang, country, hyphPathNames);
        if (key == null) {
            key = llccKey;
        }
        if (additionalHyphenationFileDirectories != null) {
            String dir;
            Iterator<String> iterator = additionalHyphenationFileDirectories.iterator();
            while (iterator.hasNext() && (hTree = Hyphenator.getHyphenationTree(dir = iterator.next(), key)) == null) {
            }
        }
        if (hTree == null && (defaultHyphenationResourceStream = ResourceUtil.getResourceStream((String)("com/itextpdf/hyph/" + key + ".xml"))) != null) {
            hTree = Hyphenator.getHyphenationTree(defaultHyphenationResourceStream, key);
        }
        if (hTree != null) {
            cache.cache(llccKey, hTree);
        }
        return hTree;
    }

    public static HyphenationTree getHyphenationTree(String searchDirectory, String key) {
        String name = key + ".xml";
        try {
            InputStream fis = FileUtil.getInputStreamForFile((String)(searchDirectory + File.separator + name));
            return Hyphenator.getHyphenationTree(fis, name);
        }
        catch (IOException ioe) {
            if (log.isDebugEnabled()) {
                log.debug("I/O problem while trying to load " + name + ": " + ioe.getMessage());
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HyphenationTree getHyphenationTree(InputStream in, String name) {
        HyphenationTree hTree;
        if (in == null) {
            return null;
        }
        try {
            hTree = new HyphenationTree();
            hTree.loadPatterns(in, name);
        }
        catch (HyphenationException ex) {
            log.error("Can't load user patterns from XML file " + name + ": " + ex.getMessage());
            HyphenationTree hyphenationTree = null;
            return hyphenationTree;
        }
        finally {
            try {
                in.close();
            }
            catch (Exception exception) {}
        }
        return hTree;
    }

    public static Hyphenation hyphenate(String lang, String country, Map<String, String> hyphPathNames, String word, int leftMin, int rightMin) {
        if (Hyphenator.wordContainsSoftHyphens(word)) {
            return Hyphenator.hyphenateBasedOnSoftHyphens(word, leftMin, rightMin);
        }
        HyphenationTree hTree = null;
        if (lang != null) {
            hTree = Hyphenator.getHyphenationTree(lang, country, hyphPathNames);
        }
        return hTree != null ? hTree.hyphenate(word, leftMin, rightMin) : null;
    }

    public static Hyphenation hyphenate(String lang, String country, String word, int leftMin, int rightMin) {
        return Hyphenator.hyphenate(lang, country, null, word, leftMin, rightMin);
    }

    public Hyphenation hyphenate(String word) {
        return Hyphenator.hyphenate(this.lang, this.country, this.hyphPathNames, word, this.leftMin, this.rightMin);
    }

    private static boolean wordContainsSoftHyphens(String word) {
        return word.indexOf(173) >= 0;
    }

    private static Hyphenation hyphenateBasedOnSoftHyphens(String word, int leftMin, int rightMin) {
        int leftInd;
        int curSoftHyphenIndex;
        ArrayList<Integer> softHyphens = new ArrayList<Integer>();
        int lastSoftHyphenIndex = -1;
        while ((curSoftHyphenIndex = word.indexOf(173, lastSoftHyphenIndex + 1)) > 0) {
            softHyphens.add(curSoftHyphenIndex);
            lastSoftHyphenIndex = curSoftHyphenIndex;
        }
        int rightInd = softHyphens.size() - 1;
        for (leftInd = 0; leftInd < softHyphens.size() && word.substring(0, (Integer)softHyphens.get(leftInd)).replace(String.valueOf('\u00ad'), "").length() < leftMin; ++leftInd) {
        }
        while (rightInd >= 0 && word.substring((Integer)softHyphens.get(rightInd) + 1).replace(String.valueOf('\u00ad'), "").length() < rightMin) {
            --rightInd;
        }
        if (leftInd <= rightInd) {
            int[] hyphenationPoints = new int[rightInd - leftInd + 1];
            for (int i = leftInd; i <= rightInd; ++i) {
                hyphenationPoints[i - leftInd] = (Integer)softHyphens.get(i);
            }
            return new Hyphenation(word, hyphenationPoints);
        }
        return null;
    }
}

