/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.kernel.pdf.canvas.parser.listener;

import com.itextpdf.kernel.geom.Rectangle;
import com.itextpdf.kernel.pdf.canvas.parser.EventType;
import com.itextpdf.kernel.pdf.canvas.parser.data.IEventData;
import com.itextpdf.kernel.pdf.canvas.parser.data.TextRenderInfo;
import com.itextpdf.kernel.pdf.canvas.parser.listener.CharacterRenderInfo;
import com.itextpdf.kernel.pdf.canvas.parser.listener.DefaultPdfTextLocation;
import com.itextpdf.kernel.pdf.canvas.parser.listener.DefaultTextChunkLocationComparator;
import com.itextpdf.kernel.pdf.canvas.parser.listener.ILocationExtractionStrategy;
import com.itextpdf.kernel.pdf.canvas.parser.listener.IPdfTextLocation;
import com.itextpdf.kernel.pdf.canvas.parser.listener.TextChunkLocationBasedComparator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class RegexBasedLocationExtractionStrategy
implements ILocationExtractionStrategy {
    private static final float EPS = 1.0E-4f;
    private final Pattern pattern;
    private final List<CharacterRenderInfo> parseResult = new ArrayList<CharacterRenderInfo>();

    public RegexBasedLocationExtractionStrategy(String regex) {
        this.pattern = Pattern.compile(regex);
    }

    public RegexBasedLocationExtractionStrategy(Pattern pattern) {
        this.pattern = pattern;
    }

    @Override
    public Collection<IPdfTextLocation> getResultantLocations() {
        Collections.sort(this.parseResult, new TextChunkLocationBasedComparator(new DefaultTextChunkLocationComparator()));
        ArrayList<IPdfTextLocation> retval = new ArrayList<IPdfTextLocation>();
        CharacterRenderInfo.StringConversionInfo txt = CharacterRenderInfo.mapString(this.parseResult);
        Matcher mat = this.pattern.matcher(txt.text);
        while (mat.find()) {
            Integer startIndex = RegexBasedLocationExtractionStrategy.getStartIndex(txt.indexMap, mat.start(), txt.text);
            Integer endIndex = RegexBasedLocationExtractionStrategy.getEndIndex(txt.indexMap, mat.end() - 1);
            if (startIndex == null || endIndex == null || startIndex > endIndex) continue;
            for (Rectangle r : this.toRectangles(this.parseResult.subList(startIndex, endIndex + 1))) {
                retval.add(new DefaultPdfTextLocation(r, mat.group(0)));
            }
        }
        Collections.sort(retval, new PdfTextLocationComparator());
        this.removeDuplicates(retval);
        return retval;
    }

    @Override
    public void eventOccurred(IEventData data, EventType type) {
        this.parseResult.addAll(this.toCRI((TextRenderInfo)data));
    }

    @Override
    public Set<EventType> getSupportedEvents() {
        return Collections.singleton(EventType.RENDER_TEXT);
    }

    protected List<CharacterRenderInfo> toCRI(TextRenderInfo tri) {
        ArrayList<CharacterRenderInfo> cris = new ArrayList<CharacterRenderInfo>();
        for (TextRenderInfo subTri : tri.getCharacterRenderInfos()) {
            cris.add(new CharacterRenderInfo(subTri));
        }
        return cris;
    }

    protected List<Rectangle> toRectangles(List<CharacterRenderInfo> cris) {
        ArrayList<Rectangle> retval = new ArrayList<Rectangle>();
        if (cris.isEmpty()) {
            return retval;
        }
        int prev = 0;
        int curr = 0;
        while (curr < cris.size()) {
            while (curr < cris.size() && cris.get(curr).sameLine(cris.get(prev))) {
                ++curr;
            }
            Rectangle resultRectangle = null;
            for (CharacterRenderInfo cri : cris.subList(prev, curr)) {
                resultRectangle = Rectangle.getCommonRectangle(resultRectangle, cri.getBoundingBox());
            }
            retval.add(resultRectangle);
            prev = curr;
        }
        return retval;
    }

    private void removeDuplicates(List<IPdfTextLocation> sortedList) {
        IPdfTextLocation lastItem = null;
        int orgSize = sortedList.size();
        for (int i = orgSize - 1; i >= 0; --i) {
            IPdfTextLocation currItem = sortedList.get(i);
            Rectangle currRect = currItem.getRectangle();
            if (lastItem != null && currRect.equalsWithEpsilon(lastItem.getRectangle())) {
                sortedList.remove(currItem);
            }
            lastItem = currItem;
        }
    }

    private static Integer getStartIndex(Map<Integer, Integer> indexMap, int index, String txt) {
        while (!indexMap.containsKey(index) && index < txt.length()) {
            ++index;
        }
        return indexMap.get(index);
    }

    private static Integer getEndIndex(Map<Integer, Integer> indexMap, int index) {
        while (!indexMap.containsKey(index) && index >= 0) {
            --index;
        }
        return indexMap.get(index);
    }

    private static final class PdfTextLocationComparator
    implements Comparator<IPdfTextLocation> {
        private PdfTextLocationComparator() {
        }

        @Override
        public int compare(IPdfTextLocation l1, IPdfTextLocation l2) {
            Rectangle o1 = l1.getRectangle();
            Rectangle o2 = l2.getRectangle();
            if (Math.abs(o1.getY() - o2.getY()) < 1.0E-4f) {
                return Math.abs(o1.getX() - o2.getX()) < 1.0E-4f ? 0 : (o2.getX() - o1.getX() > 1.0E-4f ? -1 : 1);
            }
            return o2.getY() - o1.getY() > 1.0E-4f ? -1 : 1;
        }
    }
}

