/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.kernel.font;

import com.itextpdf.io.font.FontEncoding;
import com.itextpdf.io.font.FontNames;
import com.itextpdf.io.font.TrueTypeFont;
import com.itextpdf.io.font.cmap.CMapToUnicode;
import com.itextpdf.io.font.otf.Glyph;
import com.itextpdf.kernel.PdfException;
import com.itextpdf.kernel.font.DocFontEncoding;
import com.itextpdf.kernel.font.DocTrueTypeFont;
import com.itextpdf.kernel.font.FontUtil;
import com.itextpdf.kernel.font.IDocFontProgram;
import com.itextpdf.kernel.font.PdfSimpleFont;
import com.itextpdf.kernel.pdf.PdfDictionary;
import com.itextpdf.kernel.pdf.PdfName;
import com.itextpdf.kernel.pdf.PdfStream;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PdfTrueTypeFont
extends PdfSimpleFont<TrueTypeFont> {
    private static final long serialVersionUID = -8152778382960290571L;

    PdfTrueTypeFont(TrueTypeFont ttf, String encoding, boolean embedded) {
        this.setFontProgram(ttf);
        this.embedded = embedded;
        FontNames fontNames = ttf.getFontNames();
        if (embedded && !fontNames.allowEmbedding()) {
            throw new PdfException("1.cannot.be.embedded.due.to.licensing.restrictions").setMessageParams(fontNames.getFontName());
        }
        if ((encoding == null || encoding.length() == 0) && ttf.isFontSpecific()) {
            encoding = "FontSpecific";
        }
        this.fontEncoding = encoding != null && "FontSpecific".toLowerCase().equals(encoding.toLowerCase()) ? FontEncoding.createFontSpecificEncoding() : FontEncoding.createFontEncoding((String)encoding);
    }

    PdfTrueTypeFont(PdfDictionary fontDictionary) {
        super(fontDictionary);
        this.newFont = false;
        CMapToUnicode toUni = FontUtil.processToUnicode(fontDictionary.get(PdfName.ToUnicode));
        this.fontEncoding = DocFontEncoding.createDocFontEncoding(fontDictionary.get(PdfName.Encoding), toUni, false);
        this.fontProgram = DocTrueTypeFont.createFontProgram(fontDictionary, this.fontEncoding);
        this.embedded = ((IDocFontProgram)this.fontProgram).getFontFile() != null;
        this.subset = false;
    }

    @Override
    public Glyph getGlyph(int unicode) {
        if (this.fontEncoding.canEncode(unicode)) {
            Glyph notdef;
            Glyph glyph = ((TrueTypeFont)this.getFontProgram()).getGlyph(this.fontEncoding.getUnicodeDifference(unicode));
            if (glyph == null && (glyph = (Glyph)this.notdefGlyphs.get(unicode)) == null && (notdef = ((TrueTypeFont)this.getFontProgram()).getGlyphByCode(0)) != null) {
                glyph = new Glyph(((TrueTypeFont)this.getFontProgram()).getGlyphByCode(0), unicode);
                this.notdefGlyphs.put(unicode, glyph);
            }
            return glyph;
        }
        return null;
    }

    @Override
    public boolean containsGlyph(String text, int from) {
        return this.containsGlyph((int)text.charAt(from));
    }

    @Override
    public boolean containsGlyph(int unicode) {
        if (this.fontEncoding.isFontSpecific()) {
            return this.fontProgram.getGlyphByCode(unicode) != null;
        }
        return this.fontEncoding.canEncode(unicode) && ((TrueTypeFont)this.getFontProgram()).getGlyph(this.fontEncoding.getUnicodeDifference(unicode)) != null;
    }

    @Override
    public void flush() {
        this.ensureUnderlyingObjectHasIndirectReference();
        if (this.newFont) {
            String fontName;
            PdfName subtype;
            if (((TrueTypeFont)this.getFontProgram()).isCff()) {
                subtype = PdfName.Type1;
                fontName = this.fontProgram.getFontNames().getFontName();
            } else {
                subtype = PdfName.TrueType;
                fontName = this.subset ? PdfTrueTypeFont.createSubsetPrefix() + this.fontProgram.getFontNames().getFontName() : this.fontProgram.getFontNames().getFontName();
            }
            this.flushFontData(fontName, subtype);
        }
        super.flush();
    }

    protected void addRangeUni(Set<Integer> longTag) {
        if (!(this.subset || this.subsetRanges == null && ((TrueTypeFont)this.getFontProgram()).getDirectoryOffset() <= 0)) {
            int[] nArray;
            if (this.subsetRanges == null && ((TrueTypeFont)this.getFontProgram()).getDirectoryOffset() > 0) {
                int[] nArray2 = new int[2];
                nArray2[0] = 0;
                nArray = nArray2;
                nArray2[1] = 65535;
            } else {
                nArray = PdfTrueTypeFont.compactRanges(this.subsetRanges);
            }
            int[] rg = nArray;
            Map usemap = ((TrueTypeFont)this.getFontProgram()).getActiveCmap();
            assert (usemap != null);
            for (Map.Entry e : usemap.entrySet()) {
                int[] v = (int[])e.getValue();
                int gi = v[0];
                if (longTag.contains(gi)) continue;
                int c = (Integer)e.getKey();
                boolean skip = true;
                for (int k = 0; k < rg.length; k += 2) {
                    if (c < rg[k] || c > rg[k + 1]) continue;
                    skip = false;
                    break;
                }
                if (skip) continue;
                longTag.add(gi);
            }
        }
    }

    @Override
    protected void addFontStream(PdfDictionary fontDescriptor) {
        if (this.embedded) {
            PdfStream fontStream;
            PdfName fontFileName;
            if (this.fontProgram instanceof IDocFontProgram) {
                fontFileName = ((IDocFontProgram)this.fontProgram).getFontFileName();
                fontStream = ((IDocFontProgram)this.fontProgram).getFontFile();
            } else if (((TrueTypeFont)this.getFontProgram()).isCff()) {
                fontFileName = PdfName.FontFile3;
                try {
                    byte[] fontStreamBytes = ((TrueTypeFont)this.getFontProgram()).getFontStreamBytes();
                    fontStream = this.getPdfFontStream(fontStreamBytes, new int[]{fontStreamBytes.length});
                    fontStream.put(PdfName.Subtype, new PdfName("Type1C"));
                }
                catch (PdfException e) {
                    Logger logger = LoggerFactory.getLogger(PdfTrueTypeFont.class);
                    logger.error(e.getMessage());
                    fontStream = null;
                }
            } else {
                fontFileName = PdfName.FontFile2;
                HashSet<Integer> glyphs = new HashSet<Integer>();
                for (int k = 0; k < this.shortTag.length; ++k) {
                    Glyph glyph;
                    if (this.shortTag[k] == 0) continue;
                    int uni = this.fontEncoding.getUnicode(k);
                    Glyph glyph2 = glyph = uni > -1 ? this.fontProgram.getGlyph(uni) : this.fontProgram.getGlyphByCode(k);
                    if (glyph == null) continue;
                    glyphs.add(glyph.getCode());
                }
                this.addRangeUni(glyphs);
                try {
                    byte[] fontStreamBytes = this.subset || ((TrueTypeFont)this.getFontProgram()).getDirectoryOffset() != 0 || this.subsetRanges != null ? ((TrueTypeFont)this.getFontProgram()).getSubset(new HashSet<Integer>(glyphs), this.subset) : ((TrueTypeFont)this.getFontProgram()).getFontStreamBytes();
                    fontStream = this.getPdfFontStream(fontStreamBytes, new int[]{fontStreamBytes.length});
                }
                catch (PdfException e) {
                    Logger logger = LoggerFactory.getLogger(PdfTrueTypeFont.class);
                    logger.error(e.getMessage());
                    fontStream = null;
                }
            }
            if (fontStream != null) {
                fontDescriptor.put(fontFileName, fontStream);
                if (fontStream.getIndirectReference() != null) {
                    fontStream.flush();
                }
            }
        }
    }
}

