/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.io.font.otf;

import com.itextpdf.io.font.otf.Glyph;
import com.itextpdf.io.font.otf.GlyphLine;
import com.itextpdf.io.font.otf.GposAnchor;
import com.itextpdf.io.font.otf.OpenTableLookup;
import com.itextpdf.io.font.otf.OpenTypeFontTableReader;
import com.itextpdf.io.font.otf.OtfMarkRecord;
import com.itextpdf.io.font.otf.OtfReadCommon;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class GposLookupType6
extends OpenTableLookup {
    private final List<MarkToBaseMark> marksbases = new ArrayList<MarkToBaseMark>();

    public GposLookupType6(OpenTypeFontTableReader openReader, int lookupFlag, int[] subTableLocations) throws IOException {
        super(openReader, lookupFlag, subTableLocations);
        this.readSubTables();
    }

    @Override
    public boolean transformOne(GlyphLine line) {
        if (line.getIdx() >= line.getEnd()) {
            return false;
        }
        if (this.openReader.isSkip(line.get(line.getIdx()).getCode(), this.lookupFlag)) {
            line.setIdx(line.getIdx() + 1);
            return false;
        }
        boolean changed = false;
        OpenTableLookup.GlyphIndexer gi = null;
        for (MarkToBaseMark mb : this.marksbases) {
            GposAnchor[] gpas;
            OtfMarkRecord omr = mb.marks.get(line.get(line.getIdx()).getCode());
            if (omr == null) continue;
            if (gi == null) {
                gi = new OpenTableLookup.GlyphIndexer();
                gi.setIdx(line.getIdx());
                gi.setLine(line);
                do {
                    int prev = gi.getIdx();
                    boolean foundBaseGlyph = false;
                    gi.previousGlyph(this.openReader, this.lookupFlag);
                    if (gi.getIdx() != -1) {
                        for (int i = gi.getIdx(); i < prev; ++i) {
                            if (this.openReader.getGlyphClass(line.get(i).getCode()) != 1) continue;
                            foundBaseGlyph = true;
                            break;
                        }
                    }
                    if (!foundBaseGlyph) continue;
                    gi.setGlyph(null);
                    break;
                } while (gi.getGlyph() != null && !mb.baseMarks.containsKey(gi.getGlyph().getCode()));
                if (gi.getGlyph() == null) break;
            }
            if ((gpas = mb.baseMarks.get(gi.getGlyph().getCode())) == null) continue;
            int markClass = omr.getMarkClass();
            GposAnchor baseAnchor = gpas[markClass];
            GposAnchor markAnchor = omr.getAnchor();
            line.set(line.getIdx(), new Glyph(line.get(line.getIdx()), -markAnchor.getXCoordinate() + baseAnchor.getXCoordinate(), -markAnchor.getYCoordinate() + baseAnchor.getYCoordinate(), 0, 0, gi.getIdx() - line.getIdx()));
            changed = true;
            break;
        }
        line.setIdx(line.getIdx() + 1);
        return changed;
    }

    @Override
    protected void readSubTable(int subTableLocation) throws IOException {
        this.openReader.rf.seek(subTableLocation);
        this.openReader.rf.readUnsignedShort();
        int markCoverageLocation = this.openReader.rf.readUnsignedShort() + subTableLocation;
        int baseCoverageLocation = this.openReader.rf.readUnsignedShort() + subTableLocation;
        int classCount = this.openReader.rf.readUnsignedShort();
        int markArrayLocation = this.openReader.rf.readUnsignedShort() + subTableLocation;
        int baseArrayLocation = this.openReader.rf.readUnsignedShort() + subTableLocation;
        List<Integer> markCoverage = this.openReader.readCoverageFormat(markCoverageLocation);
        List<Integer> baseCoverage = this.openReader.readCoverageFormat(baseCoverageLocation);
        List<OtfMarkRecord> markRecords = OtfReadCommon.readMarkArray(this.openReader, markArrayLocation);
        MarkToBaseMark markToBaseMark = new MarkToBaseMark();
        for (int k = 0; k < markCoverage.size(); ++k) {
            markToBaseMark.marks.put(markCoverage.get(k), markRecords.get(k));
        }
        List<GposAnchor[]> baseArray = OtfReadCommon.readBaseArray(this.openReader, classCount, baseArrayLocation);
        for (int k = 0; k < baseCoverage.size(); ++k) {
            markToBaseMark.baseMarks.put(baseCoverage.get(k), baseArray.get(k));
        }
        this.marksbases.add(markToBaseMark);
    }

    private static class MarkToBaseMark {
        public final Map<Integer, OtfMarkRecord> marks = new HashMap<Integer, OtfMarkRecord>();
        public final Map<Integer, GposAnchor[]> baseMarks = new HashMap<Integer, GposAnchor[]>();

        private MarkToBaseMark() {
        }
    }
}

