/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.io.font.otf;

import com.itextpdf.io.font.otf.Glyph;
import com.itextpdf.io.font.otf.GlyphLine;
import com.itextpdf.io.util.TextUtil;
import java.util.Iterator;

public class ActualTextIterator
implements Iterator<GlyphLine.GlyphLinePart> {
    private GlyphLine glyphLine;
    private int pos;

    public ActualTextIterator(GlyphLine glyphLine) {
        this.glyphLine = glyphLine;
        this.pos = glyphLine.getStart();
    }

    public ActualTextIterator(GlyphLine glyphLine, int start, int end) {
        this(new GlyphLine(glyphLine.glyphs, glyphLine.actualText, start, end));
    }

    @Override
    public boolean hasNext() {
        return this.pos < this.glyphLine.getEnd();
    }

    @Override
    public GlyphLine.GlyphLinePart next() {
        if (this.glyphLine.actualText == null) {
            GlyphLine.GlyphLinePart result = new GlyphLine.GlyphLinePart(this.pos, this.glyphLine.getEnd(), null);
            this.pos = this.glyphLine.getEnd();
            return result;
        }
        GlyphLine.GlyphLinePart currentResult = this.nextGlyphLinePart(this.pos);
        if (currentResult == null) {
            return null;
        }
        this.pos = currentResult.getEnd();
        if (!this.glyphLinePartNeedsActualText(currentResult)) {
            GlyphLine.GlyphLinePart nextResult;
            currentResult.setActualText(null);
            while (this.pos < this.glyphLine.getEnd() && (nextResult = this.nextGlyphLinePart(this.pos)) != null && !this.glyphLinePartNeedsActualText(nextResult)) {
                currentResult.setEnd(nextResult.getEnd());
                this.pos = nextResult.getEnd();
            }
        }
        return currentResult;
    }

    @Override
    public void remove() {
        throw new IllegalStateException("Operation not supported");
    }

    private GlyphLine.GlyphLinePart nextGlyphLinePart(int pos) {
        if (pos >= this.glyphLine.getEnd()) {
            return null;
        }
        int startPos = pos;
        GlyphLine.ActualText startActualText = this.glyphLine.actualText.get(pos);
        while (pos < this.glyphLine.getEnd() && this.glyphLine.actualText.get(pos) == startActualText) {
            ++pos;
        }
        return new GlyphLine.GlyphLinePart(startPos, pos, startActualText != null ? startActualText.getValue() : null);
    }

    private boolean glyphLinePartNeedsActualText(GlyphLine.GlyphLinePart glyphLinePart) {
        if (glyphLinePart.getActualText() == null) {
            return false;
        }
        boolean needsActualText = false;
        StringBuilder toUnicodeMapResult = new StringBuilder();
        for (int i = glyphLinePart.getStart(); i < glyphLinePart.getEnd(); ++i) {
            Glyph currentGlyph = this.glyphLine.glyphs.get(i);
            if (!currentGlyph.hasValidUnicode()) {
                needsActualText = true;
                break;
            }
            toUnicodeMapResult.append(TextUtil.convertFromUtf32(currentGlyph.getUnicode()));
        }
        return needsActualText || !toUnicodeMapResult.toString().equals(glyphLinePart.getActualText());
    }
}

