/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.html2pdf.attach.impl;

import com.itextpdf.commons.datastructures.Tuple2;
import com.itextpdf.commons.utils.MessageFormatUtil;
import com.itextpdf.html2pdf.attach.IOutlineMarkExtractor;
import com.itextpdf.html2pdf.attach.ITagWorker;
import com.itextpdf.html2pdf.attach.ProcessorContext;
import com.itextpdf.html2pdf.attach.impl.TagOutlineMarkExtractor;
import com.itextpdf.kernel.pdf.PdfDictionary;
import com.itextpdf.kernel.pdf.PdfOutline;
import com.itextpdf.kernel.pdf.action.PdfAction;
import com.itextpdf.layout.element.IElement;
import com.itextpdf.styledxmlparser.node.IElementNode;
import com.itextpdf.styledxmlparser.node.impl.jsoup.node.JsoupElementNode;
import java.util.Deque;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OutlineHandler {
    private static final String DEFAULT_DESTINATION_NAME_PREFIX = "pdfHTML-iText-outline-";
    private Map<String, Integer> destCounter = new HashMap<String, Integer>();
    protected PdfOutline currentOutline;
    protected Deque<Tuple2<String, PdfDictionary>> destinationsInProcess = new LinkedList<Tuple2<String, PdfDictionary>>();
    protected Deque<Integer> levelsInProcess = new LinkedList<Integer>();
    private Map<String, Integer> markPrioritiesMapping = new HashMap<String, Integer>();
    private String destinationNamePrefix = "pdfHTML-iText-outline-";
    protected IOutlineMarkExtractor markExtractor = new TagOutlineMarkExtractor();

    public static OutlineHandler createStandardHandler() {
        OutlineHandler handler = new OutlineHandler();
        handler.putMarkPriorityMapping("h1", 1);
        handler.putMarkPriorityMapping("h2", 2);
        handler.putMarkPriorityMapping("h3", 3);
        handler.putMarkPriorityMapping("h4", 4);
        handler.putMarkPriorityMapping("h5", 5);
        handler.putMarkPriorityMapping("h6", 6);
        return handler;
    }

    public static OutlineHandler createHandler(IOutlineMarkExtractor extractor) {
        OutlineHandler handler = new OutlineHandler();
        handler.markExtractor = extractor;
        return handler;
    }

    public IOutlineMarkExtractor getMarkExtractor() {
        return this.markExtractor;
    }

    public OutlineHandler setMarkExtractor(IOutlineMarkExtractor extractor) {
        this.markExtractor = extractor;
        return this;
    }

    public OutlineHandler putMarkPriorityMapping(String markName, Integer priority) {
        this.markPrioritiesMapping.put(markName, priority);
        return this;
    }

    public OutlineHandler putAllMarksPriorityMappings(Map<String, Integer> mappings) {
        this.markPrioritiesMapping.putAll(mappings);
        return this;
    }

    public Integer getMarkPriorityMapping(String markName) {
        return this.markPrioritiesMapping.get(markName);
    }

    public boolean hasMarkPriorityMapping(String markName) {
        if (markName == null) {
            return false;
        }
        return this.markPrioritiesMapping.containsKey(markName);
    }

    public void reset() {
        this.currentOutline = null;
        this.destinationsInProcess.clear();
        this.levelsInProcess.clear();
        this.destCounter.clear();
    }

    public void setDestinationNamePrefix(String destinationNamePrefix) {
        this.destinationNamePrefix = destinationNamePrefix;
    }

    public String getDestinationNamePrefix() {
        return this.destinationNamePrefix;
    }

    protected String generateUniqueDestinationName(IElementNode element) {
        return this.getUniqueID(this.destinationNamePrefix);
    }

    protected String generateOutlineName(IElementNode element) {
        String markName = this.markExtractor.getMark(element);
        String content = ((JsoupElementNode)element).text();
        if (content.isEmpty()) {
            content = this.getUniqueID(markName);
        }
        return content;
    }

    protected OutlineHandler addOutlineAndDestToDocument(ITagWorker tagWorker, IElementNode element, ProcessorContext context) {
        String markName = this.markExtractor.getMark(element);
        if (null != tagWorker && this.hasMarkPriorityMapping(markName) && context.getPdfDocument() != null) {
            int level = this.getMarkPriorityMapping(markName);
            if (null == this.currentOutline) {
                this.currentOutline = context.getPdfDocument().getOutlines(false);
            }
            PdfOutline parent = this.currentOutline;
            while (!this.levelsInProcess.isEmpty() && level <= this.levelsInProcess.getFirst()) {
                parent = parent.getParent();
                this.levelsInProcess.pop();
            }
            PdfOutline outline = parent.addOutline(this.generateOutlineName(element));
            String destination = this.generateUniqueDestinationName(element);
            PdfAction action = PdfAction.createGoTo((String)destination);
            outline.addAction(action);
            this.destinationsInProcess.push((Tuple2<String, PdfDictionary>)new Tuple2((Object)destination, (Object)action.getPdfObject()));
            this.levelsInProcess.push(level);
            this.currentOutline = outline;
        }
        return this;
    }

    protected OutlineHandler setDestinationToElement(ITagWorker tagWorker, IElementNode element) {
        String markName = this.markExtractor.getMark(element);
        if (null != tagWorker && this.hasMarkPriorityMapping(markName) && this.destinationsInProcess.size() > 0) {
            Tuple2<String, PdfDictionary> content = this.destinationsInProcess.pop();
            if (tagWorker.getElementResult() instanceof IElement) {
                tagWorker.getElementResult().setProperty(17, content);
            } else {
                Logger logger = LoggerFactory.getLogger(OutlineHandler.class);
                logger.warn(MessageFormatUtil.format((String)"Tag worker does not produce IPropertyContainer for \"{0}\" tag. An outline for \"{0}\" tag will not be created.", (Object[])new Object[]{markName}));
            }
        }
        return this;
    }

    private String getUniqueID(String key) {
        if (!this.destCounter.containsKey(key)) {
            this.destCounter.put(key, 1);
        }
        int id = this.destCounter.get(key);
        this.destCounter.put(key, id + 1);
        return key + id;
    }
}

