/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.html2pdf.css.apply.util;

import com.itextpdf.html2pdf.attach.ProcessorContext;
import com.itextpdf.io.util.MessageFormatUtil;
import com.itextpdf.layout.IPropertyContainer;
import com.itextpdf.layout.property.UnitValue;
import com.itextpdf.styledxmlparser.css.util.CssDimensionParsingUtils;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PositionApplierUtil {
    private static final Logger logger = LoggerFactory.getLogger(PositionApplierUtil.class);

    private PositionApplierUtil() {
    }

    public static void applyPosition(Map<String, String> cssProps, ProcessorContext context, IPropertyContainer element) {
        String position = cssProps.get("position");
        if ("absolute".equals(position)) {
            element.setProperty(52, (Object)3);
            PositionApplierUtil.applyLeftRightTopBottom(cssProps, context, element, position);
        } else if ("relative".equals(position)) {
            element.setProperty(52, (Object)2);
            PositionApplierUtil.applyLeftRightTopBottom(cssProps, context, element, position);
        } else if ("fixed".equals(position)) {
            // empty if block
        }
    }

    private static void applyLeftRightTopBottom(Map<String, String> cssProps, ProcessorContext context, IPropertyContainer element, String position) {
        float em = CssDimensionParsingUtils.parseAbsoluteLength((String)cssProps.get("font-size"));
        float rem = context.getCssContext().getRootFontSize();
        if ("relative".equals(position) && cssProps.containsKey("left") && cssProps.containsKey("right")) {
            boolean isRtl = "rtl".equals(cssProps.get("direction"));
            if (isRtl) {
                PositionApplierUtil.applyRightProperty(cssProps, element, em, rem, 54);
            } else {
                PositionApplierUtil.applyLeftProperty(cssProps, element, em, rem, 34);
            }
        } else {
            PositionApplierUtil.applyLeftProperty(cssProps, element, em, rem, 34);
            PositionApplierUtil.applyRightProperty(cssProps, element, em, rem, 54);
        }
        PositionApplierUtil.applyTopProperty(cssProps, element, em, rem, 73);
        PositionApplierUtil.applyBottomProperty(cssProps, element, em, rem, 14);
    }

    private static void applyLeftProperty(Map<String, String> cssProps, IPropertyContainer element, float em, float rem, int layoutPropertyMapping) {
        String left = cssProps.get("left");
        UnitValue leftVal = CssDimensionParsingUtils.parseLengthValueToPt((String)left, (float)em, (float)rem);
        if (leftVal != null) {
            if (leftVal.isPointValue()) {
                element.setProperty(layoutPropertyMapping, (Object)Float.valueOf(leftVal.getValue()));
            } else {
                logger.error(MessageFormatUtil.format((String)"Css property {0} in percents is not supported", (Object[])new Object[]{"left"}));
            }
        }
    }

    private static void applyRightProperty(Map<String, String> cssProps, IPropertyContainer element, float em, float rem, int layoutPropertyMapping) {
        String right = cssProps.get("right");
        UnitValue rightVal = CssDimensionParsingUtils.parseLengthValueToPt((String)right, (float)em, (float)rem);
        if (rightVal != null) {
            if (rightVal.isPointValue()) {
                element.setProperty(layoutPropertyMapping, (Object)Float.valueOf(rightVal.getValue()));
            } else {
                logger.error(MessageFormatUtil.format((String)"Css property {0} in percents is not supported", (Object[])new Object[]{"right"}));
            }
        }
    }

    private static void applyTopProperty(Map<String, String> cssProps, IPropertyContainer element, float em, float rem, int layoutPropertyMapping) {
        String top = cssProps.get("top");
        UnitValue topVal = CssDimensionParsingUtils.parseLengthValueToPt((String)top, (float)em, (float)rem);
        if (topVal != null) {
            if (topVal.isPointValue()) {
                element.setProperty(layoutPropertyMapping, (Object)Float.valueOf(topVal.getValue()));
            } else {
                logger.error(MessageFormatUtil.format((String)"Css property {0} in percents is not supported", (Object[])new Object[]{"top"}));
            }
        }
    }

    private static void applyBottomProperty(Map<String, String> cssProps, IPropertyContainer element, float em, float rem, int layoutPropertyMapping) {
        String bottom = cssProps.get("bottom");
        UnitValue bottomVal = CssDimensionParsingUtils.parseLengthValueToPt((String)bottom, (float)em, (float)rem);
        if (bottomVal != null) {
            if (bottomVal.isPointValue()) {
                element.setProperty(layoutPropertyMapping, (Object)Float.valueOf(bottomVal.getValue()));
            } else {
                logger.error(MessageFormatUtil.format((String)"Css property {0} in percents is not supported", (Object[])new Object[]{"bottom"}));
            }
        }
    }
}

