/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.html2pdf.css.apply.util;

import com.itextpdf.html2pdf.attach.ProcessorContext;
import com.itextpdf.layout.property.UnitValue;
import com.itextpdf.styledxmlparser.css.util.CssUtils;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class SupportedColColgroupPropertiesUtil {
    private static final Set<String> CELL_CSS_PROPERTIES = new HashSet<String>(Arrays.asList("background-color", "background-image", "background-position-x", "background-position-y", "background-size", "background-repeat", "background-origin", "background-clip", "background-attachment"));
    private static final Set<String> OWN_CSS_PROPERTIES = new HashSet<String>(Arrays.asList("border-bottom-color", "border-bottom-style", "border-bottom-width", "border-left-color", "border-left-style", "border-left-width", "border-right-color", "border-right-style", "border-right-width", "border-top-color", "border-top-style", "border-top-width", "visibility"));

    public static UnitValue getWidth(Map<String, String> resolvedCssProps, ProcessorContext context) {
        float em = CssUtils.parseAbsoluteLength((String)resolvedCssProps.get("font-size"));
        String width = resolvedCssProps.get("width");
        return width != null ? CssUtils.parseLengthValueToPt((String)width, (float)em, (float)context.getCssContext().getRootFontSize()) : null;
    }

    public static Map<String, String> getCellProperties(Map<String, String> resolvedCssProps) {
        return SupportedColColgroupPropertiesUtil.getFilteredMap(resolvedCssProps, CELL_CSS_PROPERTIES);
    }

    public static Map<String, String> getOwnProperties(Map<String, String> resolvedCssProps) {
        return SupportedColColgroupPropertiesUtil.getFilteredMap(resolvedCssProps, OWN_CSS_PROPERTIES);
    }

    private static Map<String, String> getFilteredMap(Map<String, String> map, Set<String> supportedKeys) {
        HashMap<String, String> result = new HashMap<String, String>();
        if (map != null) {
            for (String key : supportedKeys) {
                String value = map.get(key);
                if (value == null) continue;
                result.put(key, value);
            }
        }
        return result.size() > 0 ? result : null;
    }
}

