/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.html2pdf.attach.impl.tags;

import com.itextpdf.html2pdf.attach.ITagWorker;
import com.itextpdf.html2pdf.attach.ProcessorContext;
import com.itextpdf.html2pdf.attach.impl.layout.form.element.TextArea;
import com.itextpdf.html2pdf.attach.impl.tags.IDisplayAware;
import com.itextpdf.html2pdf.attach.impl.tags.PlaceholderTagWorker;
import com.itextpdf.layout.IPropertyContainer;
import com.itextpdf.layout.element.Paragraph;
import com.itextpdf.styledxmlparser.css.util.CssUtils;
import com.itextpdf.styledxmlparser.node.IElementNode;

public class TextAreaTagWorker
implements ITagWorker,
IDisplayAware {
    private static final String DEFAULT_TEXTAREA_NAME = "TextArea";
    private TextArea textArea;
    private String display;

    public TextAreaTagWorker(IElementNode element, ProcessorContext context) {
        String name = element.getAttribute("id");
        if (name == null) {
            name = DEFAULT_TEXTAREA_NAME;
        }
        name = context.getFormFieldNameResolver().resolveFormName(name);
        this.textArea = new TextArea(name);
        Integer rows = CssUtils.parseInteger((String)element.getAttribute("rows"));
        Integer cols = CssUtils.parseInteger((String)element.getAttribute("cols"));
        this.textArea.setProperty(0x100008, rows);
        this.textArea.setProperty(0x100007, cols);
        this.textArea.setProperty(0x100003, !context.isCreateAcroForm());
        this.textArea.setProperty(0x10000F, element.getAttribute("lang"));
        String placeholder = element.getAttribute("placeholder");
        if (null != placeholder) {
            Paragraph paragraph = placeholder.isEmpty() ? new Paragraph() : (placeholder.trim().isEmpty() ? new Paragraph("\u00a0") : new Paragraph(placeholder));
            this.textArea.setPlaceholder((Paragraph)paragraph.setMargin(0.0f));
        }
        this.display = element.getStyles() != null ? (String)element.getStyles().get("display") : null;
    }

    @Override
    public void processEnd(IElementNode element, ProcessorContext context) {
    }

    @Override
    public boolean processContent(String content, ProcessorContext context) {
        if (content.startsWith("\r\n")) {
            content = content.substring(2);
        } else if (content.startsWith("\r") || content.startsWith("\n")) {
            content = content.substring(1);
        }
        this.textArea.setProperty(0x100005, content);
        return true;
    }

    @Override
    public boolean processTagChild(ITagWorker childTagWorker, ProcessorContext context) {
        return childTagWorker instanceof PlaceholderTagWorker && null != this.textArea.getPlaceholder();
    }

    @Override
    public IPropertyContainer getElementResult() {
        return this.textArea;
    }

    @Override
    public String getDisplay() {
        return this.display;
    }
}

