/*
 * Decompiled with CFR 0.152.
 */
package com.intelligt.modbus.jlibmodbus.serial;

import com.intelligt.modbus.jlibmodbus.Modbus;
import com.intelligt.modbus.jlibmodbus.serial.SerialParameters;
import com.intelligt.modbus.jlibmodbus.serial.SerialPort;
import com.intelligt.modbus.jlibmodbus.serial.SerialPortException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.concurrent.atomic.AtomicBoolean;
import purejavacomm.CommPort;
import purejavacomm.CommPortIdentifier;
import purejavacomm.NoSuchPortException;
import purejavacomm.SerialPortEvent;
import purejavacomm.SerialPortEventListener;
import purejavacomm.UnsupportedCommOperationException;

public class SerialPortPJC
extends SerialPort
implements SerialPortEventListener {
    private purejavacomm.SerialPort port;
    private final AtomicBoolean opened = new AtomicBoolean(false);
    private InputStream in;
    private OutputStream out;

    public SerialPortPJC(SerialParameters sp) {
        super(sp);
    }

    @Override
    public void write(int b) throws IOException {
        if (!this.isOpened()) {
            throw new IOException("Port not opened");
        }
        try {
            this.out.write((byte)b);
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    @Override
    public void write(byte[] bytes) throws IOException {
        if (!this.isOpened()) {
            throw new IOException("Port not opened");
        }
        try {
            this.out.write(bytes);
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    @Override
    public void open() throws SerialPortException {
        try {
            SerialParameters sp = this.getSerialParameters();
            CommPortIdentifier portIdentifier = CommPortIdentifier.getPortIdentifier((String)sp.getDevice());
            if (portIdentifier.isCurrentlyOwned()) {
                String msg = "Cannot open serial port " + sp.getDevice();
                Modbus.log().warning(msg);
                throw new SerialPortException(msg);
            }
            CommPort commPort = portIdentifier.open(this.getClass().getName(), 3000);
            if (commPort instanceof purejavacomm.SerialPort) {
                this.port = (purejavacomm.SerialPort)commPort;
                this.port.setSerialPortParams(sp.getBaudRate(), sp.getDataBits(), sp.getStopBits(), sp.getParity().getValue());
                this.port.setFlowControlMode(0);
                this.in = this.port.getInputStream();
                this.out = this.port.getOutputStream();
                this.port.enableReceiveTimeout(this.getReadTimeout());
                this.setOpened(true);
            } else {
                Modbus.log().severe(sp.getDevice() + " is not a serial port.");
            }
        }
        catch (NoSuchPortException e) {
            throw new SerialPortException((Exception)((Object)e));
        }
        catch (Exception ex) {
            throw new SerialPortException(ex);
        }
    }

    @Override
    public void setReadTimeout(int readTimeout) {
        super.setReadTimeout(readTimeout);
        try {
            if (this.isOpened()) {
                this.port.enableReceiveTimeout(readTimeout);
            }
        }
        catch (UnsupportedCommOperationException e) {
            Modbus.log().warning(e.getLocalizedMessage());
        }
    }

    @Override
    public int read() throws IOException {
        int c;
        if (!this.isOpened()) {
            throw new IOException("Port not opened");
        }
        try {
            c = this.in.read();
        }
        catch (Exception e) {
            throw new IOException(e);
        }
        if (c > -1) {
            return c;
        }
        throw new IOException("Read timeout");
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int c;
        if (!this.isOpened()) {
            throw new IOException("Port not opened");
        }
        try {
            c = this.in.read(b, off, len);
        }
        catch (Exception e) {
            throw new IOException(e);
        }
        if (c > -1) {
            return c;
        }
        throw new IOException("Read timeout");
    }

    @Override
    public void close() {
        try {
            if (this.isOpened()) {
                this.setOpened(false);
                this.in.close();
                this.out.close();
                this.port.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public boolean isOpened() {
        return this.opened.get();
    }

    public void setOpened(boolean opened) {
        this.opened.set(opened);
    }

    public void serialEvent(SerialPortEvent serialPortEvent) {
        switch (serialPortEvent.getEventType()) {
            case 7: 
            case 8: 
            case 9: {
                Modbus.log().warning(this.port.getName() + ": framing error.");
                break;
            }
        }
    }
}

