/*
 * Decompiled with CFR 0.152.
 */
package com.intelligt.modbus.jlibmodbus.serial;

import com.intelligt.modbus.jlibmodbus.Modbus;
import com.intelligt.modbus.jlibmodbus.net.stream.InputStreamTCP;
import com.intelligt.modbus.jlibmodbus.net.stream.OutputStreamTCP;
import com.intelligt.modbus.jlibmodbus.serial.SerialParameters;
import com.intelligt.modbus.jlibmodbus.serial.SerialPort;
import com.intelligt.modbus.jlibmodbus.serial.SerialPortAbstractFactory;
import com.intelligt.modbus.jlibmodbus.serial.SerialPortException;
import com.intelligt.modbus.jlibmodbus.tcp.TcpParameters;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketException;
import java.util.Arrays;
import java.util.List;

public class SerialPortFactoryTcpClient
extends SerialPortAbstractFactory {
    private TcpParameters tcpParameters;

    public SerialPortFactoryTcpClient(TcpParameters tcpParameters) {
        super(SerialPortFactoryTcpClient.class.getCanonicalName(), "tcp-client");
        this.setTcpParameters(tcpParameters);
    }

    public TcpParameters getTcpParameters() {
        return this.tcpParameters;
    }

    public void setTcpParameters(TcpParameters tcpParameters) {
        this.tcpParameters = tcpParameters;
    }

    @Override
    public SerialPort createSerialImpl(SerialParameters sp) {
        return new SerialPortTcpClient(sp);
    }

    @Override
    public List<String> getPortIdentifiersImpl() {
        return Arrays.asList(new String[0]);
    }

    private class SerialPortTcpClient
    extends SerialPort {
        private Socket socket;
        private InputStreamTCP is;
        private OutputStreamTCP os;

        SerialPortTcpClient(SerialParameters sp) {
            super(sp);
        }

        @Override
        public void open() throws SerialPortException {
            TcpParameters parameters = SerialPortFactoryTcpClient.this.getTcpParameters();
            if (parameters != null) {
                this.close();
                this.socket = new Socket();
                InetSocketAddress isa = new InetSocketAddress(parameters.getHost(), parameters.getPort());
                try {
                    this.socket.connect(isa, 3000);
                    this.socket.setKeepAlive(parameters.isKeepAlive());
                    this.socket.setSoTimeout(this.getReadTimeout());
                    this.is = new InputStreamTCP(this.socket);
                    this.os = new OutputStreamTCP(this.socket);
                }
                catch (SocketException e) {
                    throw new SerialPortException(e);
                }
                catch (IOException e) {
                    throw new SerialPortException(e);
                }
            }
        }

        @Override
        public void write(byte[] b) throws IOException {
            if (!this.isOpened()) {
                throw new IOException("Port not opened");
            }
            this.os.write(b);
            this.os.flush();
        }

        @Override
        public void write(int b) throws IOException {
            if (!this.isOpened()) {
                throw new IOException("Port not opened");
            }
            this.os.write(b);
            this.os.flush();
        }

        @Override
        public int read() throws IOException {
            if (this.isOpened()) {
                return this.is.read();
            }
            throw new IOException("Port not opened");
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            if (this.isOpened()) {
                return this.is.read(b, off, len);
            }
            throw new IOException("Port not opened");
        }

        @Override
        public void close() {
            try {
                if (this.isOpened()) {
                    this.is.close();
                    this.os.close();
                    this.socket.close();
                }
            }
            catch (IOException e) {
                Modbus.log().warning("Unable to close port: " + e.getLocalizedMessage());
            }
            finally {
                this.is = null;
                this.os = null;
                this.socket = null;
            }
        }

        @Override
        public void setReadTimeout(int readTimeout) {
            super.setReadTimeout(readTimeout);
            if (this.isOpened()) {
                try {
                    this.socket.setSoTimeout(readTimeout);
                }
                catch (SocketException e) {
                    e.printStackTrace();
                    Modbus.log().warning("Unable to set readTimeout: " + e.getLocalizedMessage());
                }
            }
        }

        @Override
        public boolean isOpened() {
            return this.socket != null && this.socket.isConnected() && this.os != null && this.is != null;
        }
    }
}

