/*
 * Decompiled with CFR 0.152.
 */
package com.intelligt.modbus.jlibmodbus.net.transport;

import com.intelligt.modbus.jlibmodbus.exception.ModbusIOException;
import com.intelligt.modbus.jlibmodbus.exception.ModbusNumberException;
import com.intelligt.modbus.jlibmodbus.msg.ModbusMessageFactory;
import com.intelligt.modbus.jlibmodbus.msg.base.ModbusMessage;
import com.intelligt.modbus.jlibmodbus.net.stream.InputStreamTCP;
import com.intelligt.modbus.jlibmodbus.net.stream.OutputStreamTCP;
import com.intelligt.modbus.jlibmodbus.net.stream.base.LoggingInputStream;
import com.intelligt.modbus.jlibmodbus.net.stream.base.LoggingOutputStream;
import com.intelligt.modbus.jlibmodbus.net.transport.ModbusTransport;
import com.intelligt.modbus.jlibmodbus.tcp.TcpAduHeader;
import java.io.IOException;
import java.net.Socket;

class ModbusTransportTCP
extends ModbusTransport {
    private final Socket socket;

    ModbusTransportTCP(Socket socket) throws IOException {
        super(new InputStreamTCP(socket), new OutputStreamTCP(socket));
        this.socket = socket;
    }

    @Override
    protected ModbusMessage read(ModbusMessageFactory factory) throws ModbusNumberException, ModbusIOException {
        LoggingInputStream is = this.getInputStream();
        TcpAduHeader header = new TcpAduHeader();
        header.read(is);
        try {
            ModbusMessage msg = this.createMessage(factory);
            msg.setTransactionId(header.getTransactionId());
            msg.setProtocolId(header.getProtocolId());
            return msg;
        }
        catch (IOException e) {
            throw new ModbusIOException(e);
        }
    }

    @Override
    public void sendImpl(ModbusMessage msg) throws ModbusIOException {
        LoggingOutputStream os = this.getOutputStream();
        TcpAduHeader header = new TcpAduHeader();
        header.setProtocolId(msg.getProtocolId());
        header.setTransactionId(msg.getTransactionId());
        header.setPduSize(msg.size());
        header.write(os);
        msg.write(os);
    }

    @Override
    public void close() throws IOException {
        this.socket.close();
    }
}

