/*
 * Decompiled with CFR 0.152.
 */
package com.intelligt.modbus.jlibmodbus.net.transport;

import com.intelligt.modbus.jlibmodbus.exception.ModbusIOException;
import com.intelligt.modbus.jlibmodbus.exception.ModbusNumberException;
import com.intelligt.modbus.jlibmodbus.msg.ModbusMessageFactory;
import com.intelligt.modbus.jlibmodbus.msg.ModbusRequestFactory;
import com.intelligt.modbus.jlibmodbus.msg.base.ModbusMessage;
import com.intelligt.modbus.jlibmodbus.msg.base.ModbusRequest;
import com.intelligt.modbus.jlibmodbus.net.stream.base.LoggingInputStream;
import com.intelligt.modbus.jlibmodbus.net.stream.base.LoggingOutputStream;
import java.io.IOException;

public abstract class ModbusTransport {
    private final LoggingInputStream is;
    private final LoggingOutputStream os;

    ModbusTransport(LoggingInputStream is, LoggingOutputStream os) {
        this.is = is;
        this.os = os;
    }

    public void close() throws IOException {
        this.is.close();
        this.os.close();
    }

    protected ModbusMessage createMessage(ModbusMessageFactory factory) throws IOException, ModbusNumberException, ModbusIOException {
        int serverAddress = this.is.read();
        int functionCode = this.is.read();
        ModbusMessage msg = factory.createMessage(functionCode);
        msg.setServerAddress(serverAddress);
        msg.read(this.is);
        return msg;
    }

    public ModbusMessage readRequest() throws ModbusNumberException, ModbusIOException {
        return this.readMessage(ModbusRequestFactory.getInstance());
    }

    public ModbusMessage readResponse(ModbusRequest request) throws ModbusNumberException, ModbusIOException {
        return this.readMessage(request);
    }

    public final ModbusMessage readMessage(ModbusMessageFactory factory) throws ModbusNumberException, ModbusIOException {
        try {
            ModbusMessage modbusMessage = this.read(factory);
            return modbusMessage;
        }
        finally {
            this.getInputStream().log();
        }
    }

    public void send(ModbusMessage msg) throws ModbusIOException {
        try {
            this.sendImpl(msg);
            this.getOutputStream().flush();
        }
        catch (IOException e) {
            throw new ModbusIOException(e);
        }
    }

    public LoggingInputStream getInputStream() {
        return this.is;
    }

    public LoggingOutputStream getOutputStream() {
        return this.os;
    }

    protected abstract ModbusMessage read(ModbusMessageFactory var1) throws ModbusNumberException, ModbusIOException;

    protected abstract void sendImpl(ModbusMessage var1) throws ModbusIOException;
}

