/*
 * Decompiled with CFR 0.152.
 */
package com.intelligt.modbus.jlibmodbus.net.stream.base;

import com.intelligt.modbus.jlibmodbus.Modbus;
import com.intelligt.modbus.jlibmodbus.net.stream.base.ModbusOutputStream;
import com.intelligt.modbus.jlibmodbus.utils.DataUtils;
import com.intelligt.modbus.jlibmodbus.utils.FrameEvent;
import com.intelligt.modbus.jlibmodbus.utils.FrameEventListenerList;
import com.intelligt.modbus.jlibmodbus.utils.FrameEventListenerListImpl;
import java.io.IOException;

public class LoggingOutputStream
extends ModbusOutputStream {
    private FrameEventListenerList listenerList = new FrameEventListenerListImpl();
    private static final String LOG_MESSAGE_TITLE = "Frame sent: ";
    private final ModbusOutputStream out;

    public LoggingOutputStream(ModbusOutputStream out) {
        this.out = out;
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.out.write(b);
        if (Modbus.isLoggingEnabled()) {
            super.write(b);
        }
    }

    @Override
    public void write(byte[] b, int offset, int length) throws IOException {
        this.out.write(b, offset, length);
        if (Modbus.isLoggingEnabled()) {
            super.write(b, offset, length);
        }
    }

    @Override
    public void write(int b) throws IOException {
        this.out.write(b);
        if (Modbus.isLoggingEnabled()) {
            super.write(b);
        }
    }

    @Override
    public void flush() throws IOException {
        this.out.flush();
        this.log();
    }

    public void log() {
        if (Modbus.isLoggingEnabled() && super.getFifo().size() > 0) {
            byte[] bytes = super.toByteArray();
            Modbus.log().info(LOG_MESSAGE_TITLE + DataUtils.toAscii(bytes));
            this.listenerList.fireFrameSentEvent(new FrameEvent(bytes));
            super.getFifo().reset();
        }
    }

    @Override
    public byte[] toByteArray() {
        return this.out.toByteArray();
    }

    public void setListenerList(FrameEventListenerList listenerList) {
        this.listenerList = listenerList;
    }
}

