/*
 * Decompiled with CFR 0.152.
 */
package com.intelligt.modbus.jlibmodbus.net.stream;

import com.intelligt.modbus.jlibmodbus.Modbus;
import com.intelligt.modbus.jlibmodbus.net.stream.base.LoggingInputStream;
import com.intelligt.modbus.jlibmodbus.net.stream.base.ModbusInputStream;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.net.Socket;
import java.net.SocketException;

public class InputStreamTCP
extends LoggingInputStream {
    public InputStreamTCP(final Socket s) throws IOException {
        super(new ModbusInputStream(){
            private final Socket socket;
            private final BufferedInputStream in;
            {
                this.socket = s;
                this.in = new BufferedInputStream(s.getInputStream());
            }

            @Override
            public int read() throws IOException {
                int c = this.in.read();
                if (-1 == c) {
                    throw new IOException("Input stream is closed");
                }
                return c;
            }

            @Override
            public int read(byte[] b, int off, int len) throws IOException {
                int count = 0;
                int k = 0;
                while (count < len && k != -1) {
                    k = this.in.read(b, off + count, len - count);
                    if (-1 == k) continue;
                    count += k;
                }
                return count;
            }

            @Override
            public void setReadTimeout(int readTimeout) {
                try {
                    this.socket.setSoTimeout(readTimeout);
                }
                catch (SocketException e) {
                    Modbus.log().warning(e.getLocalizedMessage());
                }
            }

            @Override
            public void close() throws IOException {
                this.in.close();
            }
        });
    }
}

