/*
 * Decompiled with CFR 0.152.
 */
package com.intelligt.modbus.jlibmodbus.net.stream;

import com.intelligt.modbus.jlibmodbus.Modbus;
import com.intelligt.modbus.jlibmodbus.exception.ModbusChecksumException;
import com.intelligt.modbus.jlibmodbus.net.stream.InputStreamSerial;
import com.intelligt.modbus.jlibmodbus.serial.SerialPort;
import com.intelligt.modbus.jlibmodbus.utils.DataUtils;
import java.io.IOException;

public class InputStreamASCII
extends InputStreamSerial {
    private int lrc = 0;

    public InputStreamASCII(SerialPort serial) {
        super(serial);
    }

    private void lrcAdd(byte b) {
        this.lrc += b;
    }

    private int lrcGet() {
        return (byte)(-this.lrc);
    }

    @Override
    public void frameCheck() throws IOException, ModbusChecksumException {
        byte c_lrc = (byte)this.lrcGet();
        byte r_lrc = (byte)this.read();
        int cr = this.readRaw();
        int lf = this.readRaw();
        if (cr != 13 || lf != Modbus.getAsciiMsgDelimiter()) {
            Modbus.log().warning("\\r\\n not received.");
        }
        if (c_lrc != r_lrc) {
            throw new ModbusChecksumException(r_lrc, c_lrc);
        }
    }

    @Override
    public void frameInit() throws IOException {
        this.lrc = 0;
        char c = (char)this.readRaw();
        if (c != ':') {
            throw new IOException("no bytes read");
        }
    }

    public int readRaw() throws IOException {
        return super.read();
    }

    @Override
    public int read() throws IOException {
        char c = (char)this.readRaw();
        int b = DataUtils.fromAscii(c, (char)this.readRaw());
        this.lrcAdd((byte)b);
        return b;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        for (int i = off; i < len; ++i) {
            b[i] = (byte)this.read();
        }
        return len;
    }
}

