/*
 * Decompiled with CFR 0.152.
 */
package com.intelligt.modbus.jlibmodbus.msg.response;

import com.intelligt.modbus.jlibmodbus.Modbus;
import com.intelligt.modbus.jlibmodbus.data.ModbusHoldingRegisters;
import com.intelligt.modbus.jlibmodbus.exception.ModbusNumberException;
import com.intelligt.modbus.jlibmodbus.msg.base.AbstractReadResponse;
import com.intelligt.modbus.jlibmodbus.net.stream.base.ModbusInputStream;
import com.intelligt.modbus.jlibmodbus.net.stream.base.ModbusOutputStream;
import com.intelligt.modbus.jlibmodbus.utils.DataUtils;
import com.intelligt.modbus.jlibmodbus.utils.ModbusFunctionCode;
import java.io.IOException;
import java.util.Arrays;

public class ReadHoldingRegistersResponse
extends AbstractReadResponse {
    private byte[] buffer = new byte[0];

    public final synchronized byte[] getBytes() {
        return Arrays.copyOf(this.buffer, this.buffer.length);
    }

    @Deprecated
    public final synchronized int[] getRegisters() {
        return DataUtils.BeToIntArray(this.buffer);
    }

    public final synchronized ModbusHoldingRegisters getHoldingRegisters() {
        ModbusHoldingRegisters mhr = new ModbusHoldingRegisters();
        mhr.setBytesBe(this.buffer);
        return mhr;
    }

    public final synchronized void setBuffer(int[] registers) throws ModbusNumberException {
        this.buffer = DataUtils.toByteArray(registers);
        this.setByteCount(this.buffer.length);
    }

    @Override
    protected final synchronized void readData(ModbusInputStream fifo) throws IOException {
        int size;
        if (this.buffer.length != this.getByteCount()) {
            this.buffer = new byte[this.getByteCount()];
        }
        if ((size = fifo.read(this.buffer, 0, this.getByteCount())) < this.getByteCount()) {
            Modbus.log().warning(this.getByteCount() + " bytes expected, but " + size + " received.");
        }
    }

    @Override
    protected final synchronized void writeData(ModbusOutputStream fifo) throws IOException {
        fifo.write(this.buffer, 0, this.getByteCount());
    }

    @Override
    public int getFunction() {
        return ModbusFunctionCode.READ_HOLDING_REGISTERS.toInt();
    }
}

