/*
 * Decompiled with CFR 0.152.
 */
package com.intelligt.modbus.jlibmodbus.msg.request;

import com.intelligt.modbus.jlibmodbus.Modbus;
import com.intelligt.modbus.jlibmodbus.data.DataHolder;
import com.intelligt.modbus.jlibmodbus.exception.ModbusNumberException;
import com.intelligt.modbus.jlibmodbus.exception.ModbusProtocolException;
import com.intelligt.modbus.jlibmodbus.msg.base.AbstractWriteMultipleRequest;
import com.intelligt.modbus.jlibmodbus.msg.base.ModbusResponse;
import com.intelligt.modbus.jlibmodbus.msg.response.WriteMultipleCoilsResponse;
import com.intelligt.modbus.jlibmodbus.net.stream.base.ModbusInputStream;
import com.intelligt.modbus.jlibmodbus.utils.DataUtils;
import com.intelligt.modbus.jlibmodbus.utils.ModbusFunctionCode;
import java.io.IOException;

public final class WriteMultipleCoilsRequest
extends AbstractWriteMultipleRequest {
    @Override
    protected Class getResponseClass() {
        return WriteMultipleCoilsResponse.class;
    }

    @Override
    protected boolean checkAddressRange(int startAddress, int quantity) {
        return Modbus.checkWriteCoilCount(quantity) && Modbus.checkStartAddress(startAddress) && Modbus.checkEndAddress(startAddress + quantity);
    }

    @Override
    public ModbusResponse process(DataHolder dataHolder) throws ModbusNumberException {
        WriteMultipleCoilsResponse response = (WriteMultipleCoilsResponse)this.getResponse();
        response.setStartAddress(this.getStartAddress());
        response.setQuantity(this.getQuantity());
        try {
            dataHolder.writeCoilRange(this.getStartAddress(), this.getCoils());
        }
        catch (ModbusProtocolException e) {
            response.setException();
            response.setModbusExceptionCode(e.getException().getValue());
        }
        return response;
    }

    @Override
    public boolean validateResponseImpl(ModbusResponse response) {
        if (!(response instanceof WriteMultipleCoilsResponse)) {
            return false;
        }
        WriteMultipleCoilsResponse r = (WriteMultipleCoilsResponse)response;
        return r.getStartAddress() == this.getStartAddress() && r.getValue() == this.getQuantity();
    }

    @Override
    public void readData(ModbusInputStream fifo) throws IOException, ModbusNumberException {
        super.readData(fifo);
        if ((int)Math.ceil((double)this.getQuantity() / 8.0) != this.getByteCount()) {
            throw new ModbusNumberException("Byte count not matches quantity/8", this.getByteCount());
        }
        if (!this.checkAddressRange(this.getStartAddress(), this.getQuantity())) {
            throw new ModbusNumberException("Coil count greater than max coil count", this.getQuantity());
        }
        this.setCoils(DataUtils.toBitsArray(this.getBytes(), this.getQuantity()));
    }

    public boolean[] getCoils() {
        return DataUtils.toBitsArray(this.getBytes(), this.getQuantity());
    }

    public void setCoils(boolean[] coils) throws ModbusNumberException {
        this.setBytes(DataUtils.toByteArray(coils));
        this.setQuantity(coils.length);
    }

    @Override
    public int getFunction() {
        return ModbusFunctionCode.WRITE_MULTIPLE_COILS.toInt();
    }
}

