/*
 * Decompiled with CFR 0.152.
 */
package com.intelligt.modbus.jlibmodbus.msg.base;

import com.intelligt.modbus.jlibmodbus.exception.ModbusNumberException;
import com.intelligt.modbus.jlibmodbus.msg.base.AbstractDataRequest;
import com.intelligt.modbus.jlibmodbus.net.stream.base.ModbusInputStream;
import com.intelligt.modbus.jlibmodbus.net.stream.base.ModbusOutputStream;
import java.io.IOException;

public abstract class AbstractMultipleRequest
extends AbstractDataRequest {
    private int quantity;

    protected AbstractMultipleRequest() {
    }

    @Override
    protected void readData(ModbusInputStream fifo) throws IOException, ModbusNumberException {
        this.setQuantity(fifo.readShortBE());
    }

    @Override
    protected void writeData(ModbusOutputStream fifo) throws IOException {
        fifo.writeShortBE(this.quantity);
    }

    @Override
    protected int dataSize() {
        return 2;
    }

    public int getQuantity() {
        return this.quantity;
    }

    public void setQuantity(int quantity) throws ModbusNumberException {
        if (!this.checkAddressRange(this.getStartAddress(), quantity)) {
            throw new ModbusNumberException("End address out of bounds", this.getStartAddress() + quantity);
        }
        this.quantity = quantity;
    }

    protected abstract boolean checkAddressRange(int var1, int var2);
}

