/*
 * Decompiled with CFR 0.152.
 */
package com.intelligt.modbus.jlibmodbus.master;

import com.intelligt.modbus.jlibmodbus.data.CommStatus;
import com.intelligt.modbus.jlibmodbus.exception.ModbusIOException;
import com.intelligt.modbus.jlibmodbus.exception.ModbusNumberException;
import com.intelligt.modbus.jlibmodbus.exception.ModbusProtocolException;
import com.intelligt.modbus.jlibmodbus.master.ModbusMaster;
import com.intelligt.modbus.jlibmodbus.msg.ModbusRequestBuilder;
import com.intelligt.modbus.jlibmodbus.msg.base.ModbusRequest;
import com.intelligt.modbus.jlibmodbus.msg.response.DiagnosticsResponse;
import com.intelligt.modbus.jlibmodbus.msg.response.GetCommEventCounterResponse;
import com.intelligt.modbus.jlibmodbus.msg.response.GetCommEventLogResponse;
import com.intelligt.modbus.jlibmodbus.msg.response.ReadExceptionStatusResponse;
import com.intelligt.modbus.jlibmodbus.msg.response.ReportSlaveIdResponse;
import com.intelligt.modbus.jlibmodbus.net.ModbusConnection;

public abstract class ModbusMasterSerial
extends ModbusMaster {
    private final CommStatus commStatus = new CommStatus();

    public ModbusMasterSerial(ModbusConnection conn) {
        super(conn);
    }

    @Override
    public final int readExceptionStatus(int serverAddress) throws ModbusProtocolException, ModbusNumberException, ModbusIOException {
        ModbusRequest request = ModbusRequestBuilder.getInstance().buildReadExceptionStatus(serverAddress);
        ReadExceptionStatusResponse response = (ReadExceptionStatusResponse)this.processRequest(request);
        return response.getExceptionStatus();
    }

    @Override
    public final byte[] reportSlaveId(int serverAddress) throws ModbusProtocolException, ModbusNumberException, ModbusIOException {
        ModbusRequest request = ModbusRequestBuilder.getInstance().buildReportSlaveId(serverAddress);
        ReportSlaveIdResponse response = (ReportSlaveIdResponse)this.processRequest(request);
        return response.getSlaveId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final CommStatus getCommEventCounter(int serverAddress) throws ModbusProtocolException, ModbusNumberException, ModbusIOException {
        ModbusRequest request = ModbusRequestBuilder.getInstance().buildGetCommEventCounter(serverAddress);
        GetCommEventCounterResponse response = (GetCommEventCounterResponse)this.processRequest(request);
        CommStatus commStatus = this.commStatus;
        synchronized (commStatus) {
            this.commStatus.setCommStatus(response.getStatus());
            this.commStatus.setEventCount(response.getEventCount());
        }
        return this.commStatus;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final CommStatus getCommEventLog(int serverAddress) throws ModbusProtocolException, ModbusNumberException, ModbusIOException {
        ModbusRequest request = ModbusRequestBuilder.getInstance().buildGetCommEventLog(serverAddress);
        GetCommEventLogResponse response = (GetCommEventLogResponse)this.processRequest(request);
        CommStatus commStatus = this.commStatus;
        synchronized (commStatus) {
            this.commStatus.setCommStatus(response.getStatus());
            this.commStatus.setEventCount(response.getEventCount());
            this.commStatus.setBusMessageCount(response.getMessageCount());
            this.commStatus.setEventQueue(response.getEventQueue());
        }
        return this.commStatus;
    }

    @Override
    public final void diagnosticsReturnQueryData(int serverAddress, int queryData) throws ModbusNumberException, ModbusProtocolException, ModbusIOException {
        this.processRequest(ModbusRequestBuilder.getInstance().buildReturnQueryData(serverAddress, queryData));
    }

    @Override
    public final void diagnosticsRestartCommunicationsOption(int serverAddress, boolean clearLog) throws ModbusNumberException, ModbusProtocolException, ModbusIOException {
        this.processRequest(ModbusRequestBuilder.getInstance().buildRestartCommunicationsOption(serverAddress, clearLog));
    }

    @Override
    public final int diagnosticsReturnDiagnosticRegister(int serverAddress) throws ModbusNumberException, ModbusProtocolException, ModbusIOException {
        ModbusRequest request = ModbusRequestBuilder.getInstance().buildReturnDiagnosticRegister(serverAddress);
        DiagnosticsResponse response = (DiagnosticsResponse)this.processRequest(request);
        return response.getSubFunctionData();
    }

    @Override
    public final void diagnosticsChangeAsciiInputDelimiter(int serverAddress, int delimiter) throws ModbusNumberException, ModbusProtocolException, ModbusIOException {
        this.processRequest(ModbusRequestBuilder.getInstance().buildChangeAsciiInputDelimiter(serverAddress, delimiter));
    }

    @Override
    public final void diagnosticsForceListenOnlyMode(int serverAddress) throws ModbusNumberException, ModbusProtocolException, ModbusIOException {
        this.processRequest(ModbusRequestBuilder.getInstance().buildForceListenOnlyMode(serverAddress));
    }

    @Override
    public final void diagnosticsClearCountersAndDiagnosticRegister(int serverAddress) throws ModbusNumberException, ModbusProtocolException, ModbusIOException {
        this.processRequest(ModbusRequestBuilder.getInstance().buildClearCountersAndDiagnosticRegister(serverAddress));
    }

    @Override
    public final int diagnosticsReturnBusMessageCount(int serverAddress) throws ModbusNumberException, ModbusProtocolException, ModbusIOException {
        ModbusRequest request = ModbusRequestBuilder.getInstance().buildReturnBusMessageCount(serverAddress);
        DiagnosticsResponse response = (DiagnosticsResponse)this.processRequest(request);
        return response.getSubFunctionData();
    }

    @Override
    public final int diagnosticsReturnBusCommunicationErrorCount(int serverAddress) throws ModbusNumberException, ModbusProtocolException, ModbusIOException {
        ModbusRequest request = ModbusRequestBuilder.getInstance().buildReturnBusCommunicationErrorCount(serverAddress);
        DiagnosticsResponse response = (DiagnosticsResponse)this.processRequest(request);
        return response.getSubFunctionData();
    }

    @Override
    public final int diagnosticsReturnBusExceptionErrorCount(int serverAddress) throws ModbusNumberException, ModbusProtocolException, ModbusIOException {
        ModbusRequest request = ModbusRequestBuilder.getInstance().buildReturnBusExceptionErrorCount(serverAddress);
        DiagnosticsResponse response = (DiagnosticsResponse)this.processRequest(request);
        return response.getSubFunctionData();
    }

    @Override
    public final int diagnosticsReturnSlaveMessageCount(int serverAddress) throws ModbusNumberException, ModbusProtocolException, ModbusIOException {
        ModbusRequest request = ModbusRequestBuilder.getInstance().buildReturnSlaveMessageCount(serverAddress);
        DiagnosticsResponse response = (DiagnosticsResponse)this.processRequest(request);
        return response.getSubFunctionData();
    }

    @Override
    public final int diagnosticsReturnSlaveNoResponseCount(int serverAddress) throws ModbusNumberException, ModbusProtocolException, ModbusIOException {
        ModbusRequest request = ModbusRequestBuilder.getInstance().buildReturnSlaveNoResponseCount(serverAddress);
        DiagnosticsResponse response = (DiagnosticsResponse)this.processRequest(request);
        return response.getSubFunctionData();
    }

    @Override
    public final int diagnosticsReturnSlaveNAKCount(int serverAddress) throws ModbusNumberException, ModbusProtocolException, ModbusIOException {
        ModbusRequest request = ModbusRequestBuilder.getInstance().buildReturnSlaveNAKCount(serverAddress);
        DiagnosticsResponse response = (DiagnosticsResponse)this.processRequest(request);
        return response.getSubFunctionData();
    }

    @Override
    public final int diagnosticsReturnSlaveBusyCount(int serverAddress) throws ModbusNumberException, ModbusProtocolException, ModbusIOException {
        ModbusRequest request = ModbusRequestBuilder.getInstance().buildReturnSlaveBusyCount(serverAddress);
        DiagnosticsResponse response = (DiagnosticsResponse)this.processRequest(request);
        return response.getSubFunctionData();
    }

    @Override
    public final int diagnosticsReturnBusCharacterOverrunCount(int serverAddress) throws ModbusNumberException, ModbusProtocolException, ModbusIOException {
        ModbusRequest request = ModbusRequestBuilder.getInstance().buildReturnBusCharacterOverrunCount(serverAddress);
        DiagnosticsResponse response = (DiagnosticsResponse)this.processRequest(request);
        return response.getSubFunctionData();
    }

    @Override
    public final void diagnosticsClearOverrunCounterAndFlag(int serverAddress) throws ModbusNumberException, ModbusProtocolException, ModbusIOException {
        this.processRequest(ModbusRequestBuilder.getInstance().buildClearOverrunCounterAndFlag(serverAddress));
    }
}

