/*
 * Decompiled with CFR 0.152.
 */
package com.intelligt.modbus.jlibmodbus.data;

import com.intelligt.modbus.jlibmodbus.Modbus;
import com.intelligt.modbus.jlibmodbus.data.ModbusValues;
import com.intelligt.modbus.jlibmodbus.exception.IllegalDataAddressException;
import com.intelligt.modbus.jlibmodbus.exception.IllegalDataValueException;
import com.intelligt.modbus.jlibmodbus.utils.DataUtils;
import java.util.Arrays;

public class ModbusHoldingRegisters
extends ModbusValues<Integer> {
    private int[] registers = new int[0];

    public ModbusHoldingRegisters(int size) {
        this.registers = new int[Modbus.checkEndAddress(size) ? size : 65535];
    }

    public ModbusHoldingRegisters() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setSize(int size) {
        ModbusHoldingRegisters modbusHoldingRegisters = this;
        synchronized (modbusHoldingRegisters) {
            if (this.registers.length != size) {
                this.registers = Arrays.copyOf(this.registers, size);
            }
        }
    }

    protected void checkOffsetAndValue(int offset, int value) throws IllegalDataValueException, IllegalDataAddressException {
        this.checkAddress(offset);
        this.checkValue(value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setImpl(int offset, Integer value) throws IllegalDataAddressException, IllegalDataValueException {
        this.checkAddress(offset);
        this.checkValue(value);
        ModbusHoldingRegisters modbusHoldingRegisters = this;
        synchronized (modbusHoldingRegisters) {
            this.registers[offset] = value;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRange(int offset, int[] range) throws IllegalDataAddressException, IllegalDataValueException {
        this.checkRange(offset, range.length);
        if (!Modbus.checkWriteRegisterCount(range.length)) {
            throw new IllegalDataAddressException(offset);
        }
        ModbusHoldingRegisters modbusHoldingRegisters = this;
        synchronized (modbusHoldingRegisters) {
            for (int i = 0; i < range.length; ++i) {
                this.set(offset + i, range[i]);
            }
        }
    }

    public void setInt8At(int offset, int i8) throws IllegalDataAddressException, IllegalDataValueException {
        this.checkOffsetAndValue(offset, i8);
        this.set(offset, Integer.valueOf(DataUtils.byteLow(i8)));
    }

    public void setInt16At(int offset, int i16) throws IllegalDataAddressException, IllegalDataValueException {
        this.checkOffsetAndValue(offset, i16);
        this.set(offset, i16);
    }

    public void setInt32At(int offset, int i32) throws IllegalDataAddressException, IllegalDataValueException {
        this.setInt16At(offset, DataUtils.wordLow(i32));
        this.setInt16At(offset + 1, DataUtils.wordHigh(i32));
    }

    public void setInt64At(int offset, long i64) throws IllegalDataAddressException, IllegalDataValueException {
        this.setInt32At(offset, (int)(i64 & 0xFFFFFFFFFFFFFFFFL));
        this.setInt32At(offset + 2, (int)(i64 >> 32 & 0xFFFFFFFFFFFFFFFFL));
    }

    public void setFloat32At(int offset, float f32) throws IllegalDataAddressException, IllegalDataValueException {
        this.setInt32At(offset, Float.floatToRawIntBits(f32));
    }

    public void setFloat64At(int offset, double f64) throws IllegalDataAddressException, IllegalDataValueException {
        this.setInt64At(offset, Double.doubleToRawLongBits(f64));
    }

    public int getInt8At(int offset) throws IllegalDataAddressException {
        this.checkAddress(offset);
        return DataUtils.byteLow(this.get(offset));
    }

    public int getInt16At(int offset) throws IllegalDataAddressException {
        return this.get(offset);
    }

    public int getInt32At(int offset) throws IllegalDataAddressException {
        return this.getInt16At(offset) & 0xFFFF | (this.getInt16At(offset + 1) & 0xFFFF) << 16;
    }

    public long getInt64At(int offset) throws IllegalDataAddressException {
        return (long)this.getInt32At(offset) & 0xFFFFFFFFL | ((long)this.getInt32At(offset + 2) & 0xFFFFFFFFL) << 32;
    }

    public float getFloat32At(int offset) throws IllegalDataAddressException {
        return Float.intBitsToFloat(this.getInt32At(offset));
    }

    public double getFloat64At(int offset) throws IllegalDataAddressException {
        return Double.longBitsToDouble(this.getInt64At(offset));
    }

    public int[] getRegisters() {
        return Arrays.copyOf(this.registers, this.getQuantity());
    }

    public void setRegisters(int[] registers) {
        this.registers = Arrays.copyOf(registers, registers.length);
    }

    @Override
    public synchronized int getByteCount() {
        return this.getQuantity() * 2;
    }

    @Override
    public byte[] getBytes() {
        return DataUtils.toByteArray(this.registers);
    }

    @Override
    public void setBytesBe(byte[] bytes) {
        this.registers = DataUtils.BeToIntArray(bytes);
    }

    public void setBytesLe(byte[] bytes) {
        this.registers = DataUtils.LeToIntArray(bytes);
    }

    @Override
    public synchronized int getQuantity() {
        return this.registers.length;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Integer get(int offset) throws IllegalDataAddressException {
        this.checkAddress(offset);
        ModbusHoldingRegisters modbusHoldingRegisters = this;
        synchronized (modbusHoldingRegisters) {
            return this.registers[offset];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] getRange(int offset, int quantity) throws IllegalDataAddressException {
        this.checkRange(offset, quantity);
        if (!Modbus.checkReadRegisterCount(quantity)) {
            throw new IllegalDataAddressException(offset);
        }
        ModbusHoldingRegisters modbusHoldingRegisters = this;
        synchronized (modbusHoldingRegisters) {
            return Arrays.copyOfRange(this.registers, offset, offset + quantity);
        }
    }

    private void checkRange(int offset, int quantity) throws IllegalDataAddressException {
        if (offset + quantity > this.getQuantity()) {
            throw new IllegalDataAddressException(offset);
        }
    }

    private void checkAddress(int offset) throws IllegalDataAddressException {
        if (offset > this.getQuantity() - 1) {
            throw new IllegalDataAddressException(offset);
        }
    }

    private void checkValue(int value) throws IllegalDataValueException {
        if (!Modbus.checkRegisterValue(value)) {
            throw new IllegalDataValueException();
        }
    }
}

