/*
 * Decompiled with CFR 0.152.
 */
package com.imadcn.framework.idworker.spring.schema.parser;

import com.imadcn.framework.idworker.config.ZookeeperConfiguration;
import com.imadcn.framework.idworker.generator.SnowflakeGenerator;
import com.imadcn.framework.idworker.registry.zookeeper.ZookeeperRegistryCenter;
import com.imadcn.framework.idworker.spring.schema.parser.BaseBeanDefinitionParser;
import com.imadcn.framework.idworker.spring.schema.parser.GeneratorRegisteryBuilder;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Element;

public class RegistryBeanDefinitionParser
extends BaseBeanDefinitionParser {
    private String registryType;

    public RegistryBeanDefinitionParser(String registryType) {
        this.registryType = registryType;
    }

    protected AbstractBeanDefinition parseInternal(Element element, ParserContext parserContext) {
        if ("registry".equals(this.registryType)) {
            BeanDefinitionBuilder result = BeanDefinitionBuilder.rootBeanDefinition(ZookeeperRegistryCenter.class);
            result.addConstructorArgValue((Object)this.buildZookeeperConfigurationBeanDefinition(element, parserContext));
            result.setInitMethodName("init");
            return result.getBeanDefinition();
        }
        if ("generator".equals(this.registryType)) {
            Class<SnowflakeGenerator> generatorClass = GeneratorRegisteryBuilder.getGeneratorClass(element);
            BeanDefinitionBuilder result = BeanDefinitionBuilder.rootBeanDefinition(generatorClass);
            if (generatorClass.isAssignableFrom(SnowflakeGenerator.class)) {
                result.addConstructorArgValue((Object)GeneratorRegisteryBuilder.buildWorkerNodeRegisterBeanDefinition(element, parserContext));
                result.setInitMethodName("init");
                result.setDestroyMethodName("destroy");
            }
            return result.getBeanDefinition();
        }
        throw new IllegalArgumentException("unknown registryType");
    }

    private AbstractBeanDefinition buildZookeeperConfigurationBeanDefinition(Element element, ParserContext parserContext) {
        BeanDefinitionBuilder result = BeanDefinitionBuilder.rootBeanDefinition(ZookeeperConfiguration.class);
        RegistryBeanDefinitionParser.addPropertyValueIfNotEmpty("server-lists", "serverLists", element, result);
        RegistryBeanDefinitionParser.addPropertyValueIfNotEmpty("namespace", "namespace", element, result);
        RegistryBeanDefinitionParser.addPropertyValueIfNotEmpty("base-sleep-time-milliseconds", "baseSleepTimeMilliseconds", element, result);
        RegistryBeanDefinitionParser.addPropertyValueIfNotEmpty("max-sleep-time-milliseconds", "maxSleepTimeMilliseconds", element, result);
        RegistryBeanDefinitionParser.addPropertyValueIfNotEmpty("max-retries", "maxRetries", element, result);
        RegistryBeanDefinitionParser.addPropertyValueIfNotEmpty("session-timeout-milliseconds", "sessionTimeoutMilliseconds", element, result);
        RegistryBeanDefinitionParser.addPropertyValueIfNotEmpty("connection-timeout-milliseconds", "connectionTimeoutMilliseconds", element, result);
        RegistryBeanDefinitionParser.addPropertyValueIfNotEmpty("digest", "digest", element, result);
        return result.getBeanDefinition();
    }
}

