/*
 * Decompiled with CFR 0.152.
 */
package com.imadcn.framework.idworker.register;

import com.imadcn.framework.idworker.register.WorkerRegister;
import com.imadcn.framework.idworker.register.zookeeper.NodeInfo;
import com.imadcn.framework.idworker.register.zookeeper.NodePath;
import com.imadcn.framework.idworker.registry.CoordinatorRegistryCenter;
import com.imadcn.framework.idworker.serialize.json.JsonSerializer;
import com.imadcn.framework.idworker.util.HostUtils;
import java.io.File;
import java.io.IOException;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Date;
import java.util.UUID;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractWorkerRegister
implements WorkerRegister {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    public static final long MAX_WORKER_NUM = 1024L;
    public static final int MAX_LOCK_WAIT_TIME_MS = 30000;
    private CoordinatorRegistryCenter regCenter;
    private String registryFile;
    private NodePath nodePath;
    private boolean durable;
    private JsonSerializer<NodeInfo> jsonSerializer;
    private boolean cachable;

    protected boolean checkNodeInfo(NodeInfo localNodeInfo, NodeInfo zkNodeInfo) {
        try {
            if (!zkNodeInfo.getNodeId().equals(localNodeInfo.getNodeId())) {
                return false;
            }
            if (!zkNodeInfo.getHostName().equals(localNodeInfo.getHostName())) {
                return false;
            }
            return zkNodeInfo.getGroupName().equals(localNodeInfo.getGroupName());
        }
        catch (Exception e) {
            this.logger.error("check node info error, {}", (Throwable)e);
            return false;
        }
    }

    protected void saveLocalNodeInfo(NodeInfo nodeInfo) throws Exception {
        try {
            File nodeInfoFile = new File(this.getRegistryFile());
            String nodeInfoJson = this.jsonizeNodeInfo(nodeInfo);
            FileUtils.writeStringToFile((File)nodeInfoFile, (String)nodeInfoJson, (Charset)StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            this.logger.error("save node info cache error, {}", (Throwable)e);
        }
    }

    protected NodeInfo getLocalNodeInfo() {
        try {
            File nodeInfoFile = new File(this.getRegistryFile());
            if (nodeInfoFile.exists()) {
                String nodeInfoJson = FileUtils.readFileToString((File)nodeInfoFile, (Charset)StandardCharsets.UTF_8);
                NodeInfo nodeInfo = this.createNodeInfoFromJsonStr(nodeInfoJson);
                return nodeInfo;
            }
        }
        catch (Exception e) {
            this.logger.error("read node info cache error, {}", (Throwable)e);
        }
        return null;
    }

    protected NodeInfo createNodeInfo(String groupName, Integer workerId) throws UnknownHostException {
        NodeInfo nodeInfo = new NodeInfo();
        nodeInfo.setNodeId(this.genNodeId());
        nodeInfo.setGroupName(groupName);
        nodeInfo.setWorkerId(workerId);
        nodeInfo.setIp(HostUtils.getLocalIP());
        nodeInfo.setHostName(HostUtils.getLocalHostName());
        nodeInfo.setCreateTime(new Date());
        nodeInfo.setUpdateTime(new Date());
        return nodeInfo;
    }

    protected NodeInfo createNodeInfoFromJsonStr(String jsonStr) throws Exception {
        return this.getJsonSerializer().parseObject(jsonStr, NodeInfo.class);
    }

    protected String jsonizeNodeInfo(NodeInfo nodeInfo) throws Exception {
        return this.getJsonSerializer().toJsonString(nodeInfo);
    }

    protected String getDefaultFilePath(String groupName) {
        StringBuilder builder = new StringBuilder();
        builder.append(".").append(File.separator).append("tmp");
        builder.append(File.separator).append("idworker");
        builder.append(File.separator).append(groupName).append(".cache");
        return builder.toString();
    }

    protected String genNodeId() {
        return UUID.randomUUID().toString().replace("-", "").toLowerCase();
    }

    protected String getNodePathKey(NodePath nodePath, Integer workerId) {
        StringBuilder builder = new StringBuilder();
        builder.append(nodePath.getWorkerPath()).append("/");
        builder.append(workerId);
        return builder.toString();
    }

    public CoordinatorRegistryCenter getRegCenter() {
        return this.regCenter;
    }

    public void setRegCenter(CoordinatorRegistryCenter regCenter) {
        this.regCenter = regCenter;
    }

    public String getRegistryFile() {
        return this.registryFile;
    }

    public void setRegistryFile(String registryFile) {
        this.registryFile = registryFile;
    }

    public boolean isDurable() {
        return this.durable;
    }

    public void setDurable(boolean durable) {
        this.durable = durable;
    }

    public JsonSerializer<NodeInfo> getJsonSerializer() {
        return this.jsonSerializer;
    }

    public void setJsonSerializer(JsonSerializer<NodeInfo> jsonSerializer) {
        this.jsonSerializer = jsonSerializer;
    }

    public boolean isCachable() {
        return this.cachable;
    }

    public void setNodePath(NodePath nodePath) {
        this.nodePath = nodePath;
    }

    public void setCachable(boolean cachable) {
        this.cachable = cachable;
    }

    public NodePath getNodePath() {
        return this.nodePath;
    }
}

