/*
 * Decompiled with CFR 0.152.
 */
package com.imadcn.framework.idworker.algorithm;

import java.util.Random;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Snowflake {
    private static final Logger logger = LoggerFactory.getLogger(Snowflake.class);
    private final long workerId;
    private final long epoch = 1483200000000L;
    private final long workerIdBits = 10L;
    private final long maxWorkerId = 1023L;
    private final long sequenceBits = 12L;
    private final long sequenceMask = 4095L;
    private final long workerIdShift = 12L;
    private final long timestampLeftShift = 22L;
    private long sequence = 0L;
    private long lastTimestamp = -1L;
    private final int HUNDRED_K = 100000;
    private static final Random RANDOM = new Random();

    private Snowflake(long workerId) {
        if (workerId > 1023L || workerId < 0L) {
            String message = String.format("worker Id can't be greater than %d or less than 0", 1023L);
            throw new IllegalArgumentException(message);
        }
        this.workerId = workerId;
    }

    public static Snowflake create(long workerId) {
        return new Snowflake(workerId);
    }

    @Deprecated
    public static Snowflake create(long workerId, boolean lowConcurrency) {
        return Snowflake.create(workerId);
    }

    public long[] nextId(int size) {
        if (size <= 0 || size > 100000) {
            String message = String.format("Size can't be greater than %d or less than 0", 100000);
            throw new IllegalArgumentException(message);
        }
        long[] ids = new long[size];
        for (int i = 0; i < size; ++i) {
            ids[i] = this.nextId();
        }
        return ids;
    }

    public synchronized long nextId() {
        long timestamp = this.timeGen();
        if (this.lastTimestamp == timestamp) {
            this.sequence = this.sequence + 1L & 0xFFFL;
            if (this.sequence == 0L) {
                this.sequence = RANDOM.nextInt(100);
                timestamp = this.tilNextMillis(this.lastTimestamp);
            }
        } else {
            this.sequence = RANDOM.nextInt(100);
        }
        if (timestamp < this.lastTimestamp) {
            String message = String.format("Clock moved backwards. Refusing to generate id for %d milliseconds.", this.lastTimestamp - timestamp);
            logger.error(message);
            throw new RuntimeException(message);
        }
        this.lastTimestamp = timestamp;
        return timestamp - 1483200000000L << 22 | this.workerId << 12 | this.sequence;
    }

    private long tilNextMillis(long lastTimestamp) {
        long timestamp = this.timeGen();
        while (timestamp <= lastTimestamp) {
            timestamp = this.timeGen();
        }
        return timestamp;
    }

    private long timeGen() {
        return System.currentTimeMillis();
    }
}

