/*
 * Decompiled with CFR 0.152.
 */
package sqlj.runtime.ref;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Map;
import java.util.Properties;
import sqlj.runtime.ConnectionContext;
import sqlj.runtime.RuntimeContext;
import sqlj.runtime.profile.Loader;
import sqlj.runtime.profile.Profile;
import sqlj.runtime.ref.ConnectionContextImpl;
import sqlj.runtime.ref.ProfileGroup;
import sqlj.runtime.util.SqljTrace;

public class DefaultContext
extends ConnectionContextImpl
implements ConnectionContext {
    private static final String m_T2zos_SQLJ_Runtime = "__T2Zos_SQLJRuntime";
    private static final ProfileGroup m_profiles = new ProfileGroup();
    private static ThreadLocal<DefaultContext> m_threadLocalContext = null;
    private static DefaultContext m_defaultContext = null;

    public static void enableThreadLocalStorage() {
        if (SqljTrace.isContextTraceOn()) {
            SqljTrace.printMessage("enableThreadLocalStorage() called ");
        }
        if (m_threadLocalContext == null) {
            m_threadLocalContext = new ThreadLocal();
            if (SqljTrace.isContextTraceOn()) {
                SqljTrace.printMessage("enableThreadLocalStorage() created context: " + m_threadLocalContext);
            }
        }
    }

    public static void freeProfileCache() {
        m_profiles.freeContextProfileCache();
        ProfileGroup.freeGlobalProfileCache();
    }

    public static void enableGlobalProfileCache() {
        ProfileGroup.enableGlobalProfileCache();
    }

    public static void disableGlobalProfileCache() {
        ProfileGroup.disableGlobalProfileCache();
    }

    public ProfileGroup getProfileGroup() {
        return m_profiles;
    }

    public void setT2ZosCachedDefaultCtxForDriverUseOnly(boolean bl2, String string) {
        if (SqljTrace.isContextTraceOn()) {
            SqljTrace.printMessage("DefaultContext.setT2ZosCachedDefaultCtxForDriverUseOnly() called for this context " + this + " calledFrom: " + string);
        }
        if (string != null && string.equals(m_T2zos_SQLJ_Runtime)) {
            this.m_isT2ZosCachedDefaultContext = bl2;
        }
    }

    public static Object getProfileKey(Loader loader, String string) throws SQLException {
        if (SqljTrace.isContextTraceOn()) {
            SqljTrace.printMessage("DefaultContext.getProfileKey() for profile " + string + " is called");
        }
        return m_profiles.getProfileKey(loader, string);
    }

    public static Profile getProfile(Object object) {
        if (SqljTrace.isContextTraceOn()) {
            SqljTrace.printMessage("DefaultContext.getProfile() for key " + ((ProfileGroup.Key)object).index + " is called");
        }
        return m_profiles.getProfile(object);
    }

    public static DefaultContext getDefaultContext() {
        DefaultContext defaultContext = null;
        if (SqljTrace.isContextTraceOn()) {
            SqljTrace.printMessage("DefaultContext.getDefaultContext() entry  " + Thread.currentThread().getName());
        }
        if (m_threadLocalContext != null) {
            defaultContext = m_threadLocalContext.get();
            if (SqljTrace.isContextTraceOn()) {
                SqljTrace.printMessage("ThreadLocal DefaultContext.getDefaultContext() returned: " + defaultContext + " Connection: " + defaultContext.getConnection() + " " + Thread.currentThread().getName());
            }
            if (defaultContext != null) {
                return defaultContext;
            }
            defaultContext = DefaultContext.createNewDefaultContext();
            if (defaultContext == null) {
                defaultContext = m_threadLocalContext.get();
            }
            return defaultContext;
        }
        if (m_defaultContext == null) {
            defaultContext = DefaultContext.createNewDefaultContext();
            if (m_defaultContext == null && defaultContext != null) {
                m_defaultContext = defaultContext;
            }
        }
        if (SqljTrace.isContextTraceOn()) {
            SqljTrace.printMessage("DefaultContext.getDefaultContext() exit returned: " + m_defaultContext + " Connection:" + defaultContext.getConnection());
        }
        return m_defaultContext;
    }

    private static DefaultContext createNewDefaultContext() {
        DefaultContext defaultContext = null;
        Connection connection = RuntimeContext.getRuntime().getDefaultConnection();
        if (connection != null) {
            try {
                defaultContext = new DefaultContext(connection);
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        return defaultContext;
    }

    public static void setDefaultContext(DefaultContext defaultContext) {
        if (m_threadLocalContext != null) {
            m_threadLocalContext.set(defaultContext);
            if (SqljTrace.isContextTraceOn()) {
                SqljTrace.printMessage("ThreadLocal DefaultContext.setDefaultContext(): " + defaultContext + " Connection: " + defaultContext.getConnection() + " " + Thread.currentThread().getName());
            }
        }
        m_defaultContext = defaultContext;
        if (SqljTrace.isContextTraceOn() && m_threadLocalContext == null) {
            SqljTrace.printMessage("DefaultContext.setDefaultContext() exit m_defaultContext : " + m_defaultContext + " Connection: " + defaultContext.getConnection());
        }
    }

    public DefaultContext(Connection connection) throws SQLException {
        super(m_profiles, connection);
        if (SqljTrace.isContextTraceOn()) {
            SqljTrace.printMessage("DefaultContext constructor exit: " + this + " Connection: " + connection);
        }
    }

    public DefaultContext(String string, String string2, String string3, boolean bl2) throws SQLException {
        super(m_profiles, string, string2, string3, bl2);
    }

    public DefaultContext(String string, Properties properties, boolean bl2) throws SQLException {
        super(m_profiles, string, properties, bl2);
    }

    public DefaultContext(String string, boolean bl2) throws SQLException {
        super(m_profiles, string, bl2);
    }

    public DefaultContext(ConnectionContext connectionContext) throws SQLException {
        super(m_profiles, connectionContext);
    }

    @Override
    public Map getTypeMap() {
        return null;
    }

    public static ThreadLocal<DefaultContext> getThreadLocalContext() {
        return m_threadLocalContext;
    }
}

