/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.cmx.tools.internal.repository;

import com.ibm.db2.cmx.runtime.internal.repository.MetadataException;
import com.ibm.db2.cmx.runtime.internal.repository.api.ManagerFactory;
import com.ibm.db2.cmx.runtime.internal.repository.api.RepositorySetupManager;
import com.ibm.db2.cmx.runtime.internal.repository.api.RepositoryVersion;
import com.ibm.db2.cmx.runtime.internal.repository.api.RuntimeGroupManager;
import com.ibm.db2.cmx.runtime.internal.repository.metadata.loader.RepositorySetupException;
import com.ibm.db2.cmx.runtime.internal.resources.Messages;
import com.ibm.db2.cmx.tools.internal.PureQueryUtility;
import com.ibm.db2.cmx.tools.internal.optionsProcessing.ArtifactOptionsSet;
import com.ibm.db2.cmx.tools.internal.optionsProcessing.PossibleArgs;
import com.ibm.db2.cmx.tools.internal.repository.DefaultActionProcessor;
import com.ibm.db2.cmx.tools.internal.repository.ManageRepositoryUtility;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.List;

public class CreateActionProcessor
extends DefaultActionProcessor {
    @Override
    public PureQueryUtility.UtilityResult processAction(PossibleArgs possibleArgs, ArtifactOptionsSet artifactOptionsSet, Connection connection, String string, RepositoryVersion repositoryVersion, PrintWriter printWriter) throws MetadataException, IOException, RepositorySetupException, SQLException {
        PureQueryUtility.UtilityResult utilityResult = null;
        PossibleArgs.PredefinedOptionValues predefinedOptionValues = artifactOptionsSet.getOptionSingleValueFromPredefinedOptionValues(PossibleArgs.CREATE);
        if (predefinedOptionValues != null) {
            if (PossibleArgs.PredefinedOptionValues.REPOSITORY.compareTo(predefinedOptionValues) == 0) {
                utilityResult = this.createRepository(artifactOptionsSet, connection, string, printWriter);
            } else if (PossibleArgs.PredefinedOptionValues.RUNTIME_GROUP == predefinedOptionValues) {
                utilityResult = this.createRuntimeGroup(artifactOptionsSet, connection, string, repositoryVersion, printWriter);
            }
        }
        return utilityResult;
    }

    private PureQueryUtility.UtilityResult createRuntimeGroup(ArtifactOptionsSet artifactOptionsSet, Connection connection, String string, RepositoryVersion repositoryVersion, PrintWriter printWriter) throws MetadataException, IOException, SQLException, FileNotFoundException {
        RuntimeGroupManager runtimeGroupManager;
        PureQueryUtility.UtilityResult utilityResult = null;
        String string2 = artifactOptionsSet.getOptionOrArtifactSingleValue(PossibleArgs.RUNTIME_GROUP_ID);
        String string3 = artifactOptionsSet.getOptionOrArtifactSingleValue(PossibleArgs.RUNTIME_GROUP_VERSION);
        String string4 = artifactOptionsSet.getOptionOrArtifactSingleValue(PossibleArgs.CONTACT_INFORMATION);
        String string5 = artifactOptionsSet.getOptionOrArtifactSingleValue(PossibleArgs.PUREQUERY_PROPERTIES);
        String string6 = artifactOptionsSet.getOptionOrArtifactSingleValue(PossibleArgs.PUREQUERY_XML_FILE);
        String string7 = artifactOptionsSet.getOptionOrArtifactSingleValue(PossibleArgs.OPTIONS_FILE_FORBIND);
        String string8 = artifactOptionsSet.getOptionOrArtifactSingleValue(PossibleArgs.OPTIONS_FILE_FORCONFIGURE);
        String string9 = artifactOptionsSet.getOptionOrArtifactSingleValue(PossibleArgs.INPUT_DIRECTORY);
        if (string9 != null && !string9.endsWith(File.separator)) {
            string9 = string9 + File.separator;
        }
        if (!ManageRepositoryUtility.runtimeGroupVersionExists(string2, string3, runtimeGroupManager = ManagerFactory.getRuntimeGroupManager(connection, string))) {
            if (ManageRepositoryUtility.isOPMRepository(repositoryVersion)) {
                ManageRepositoryUtility.validateOptionForOPM(string4, PossibleArgs.CONTACT_INFORMATION, printWriter);
                ManageRepositoryUtility.validateOptionForOPM(string5, PossibleArgs.PUREQUERY_PROPERTIES, printWriter);
                ManageRepositoryUtility.validateOptionForOPM(string7, PossibleArgs.OPTIONS_FILE_FORBIND, printWriter);
                ManageRepositoryUtility.validateOptionForOPM(string8, PossibleArgs.OPTIONS_FILE_FORCONFIGURE, printWriter);
            }
            runtimeGroupManager.create(string2, string3, string4);
            connection.commit();
            ManageRepositoryUtility.addPureQueryData(string2, string3, string5, string6, string7, string8, string9, runtimeGroupManager, repositoryVersion);
            connection.commit();
            connection.rollback();
            return new PureQueryUtility.UtilityResult(PureQueryUtility.UtilityResultType.SUCCESS);
        }
        utilityResult = new PureQueryUtility.UtilityResult(PureQueryUtility.UtilityResultType.MR_SKIP);
        utilityResult.reason = Messages.getText("MSG_ERROR_RUNTIMEGROUP_VERSION_FOUND", string2, string3);
        return utilityResult;
    }

    private PureQueryUtility.UtilityResult createRepository(ArtifactOptionsSet artifactOptionsSet, Connection connection, String string, PrintWriter printWriter) throws MetadataException, IOException, RepositorySetupException, SQLException {
        PureQueryUtility.UtilityResult utilityResult = null;
        boolean bl2 = false;
        try {
            ManagerFactory.prepareConnection(connection, false, string);
        }
        catch (MetadataException metadataException) {
            bl2 = true;
        }
        PossibleArgs.PredefinedOptionValues predefinedOptionValues = artifactOptionsSet.getOptionSingleValueFromPredefinedOptionValues(PossibleArgs.REPOSITORY_TYPE);
        RepositorySetupManager repositorySetupManager = ManagerFactory.getRepositorySetupManager(connection);
        boolean bl3 = predefinedOptionValues.compareTo(PossibleArgs.PredefinedOptionValues.PUREQUERY_ONLY) == 0;
        String string2 = artifactOptionsSet.getOptionOrArtifactSingleValue(PossibleArgs.GENERATE_SCRIPT_ONLY);
        if (string2 == null) {
            RepositoryVersion repositoryVersion = null;
            if (!bl2) {
                repositoryVersion = repositorySetupManager.getRepositoryVersion(string);
            }
            if (repositoryVersion == null) {
                repositorySetupManager.createRepository(string, RepositorySetupManager.CreateType.OnlyIfDoesNotExist, bl3, printWriter);
                return new PureQueryUtility.UtilityResult(PureQueryUtility.UtilityResultType.SUCCESS);
            }
            String string3 = connection.getMetaData().getURL();
            utilityResult = new PureQueryUtility.UtilityResult(PureQueryUtility.UtilityResultType.MR_SKIP);
            utilityResult.reason = Messages.getText("ERR_REPOSITORY_EXIST", string3.substring(string3.lastIndexOf("/") + 1, string3.length()), string3, string);
            return utilityResult;
        }
        FileWriter fileWriter = new FileWriter(string2);
        List<String> list = repositorySetupManager.getCreateScript(bl3, string);
        DatabaseMetaData databaseMetaData = connection.getMetaData();
        ManageRepositoryUtility.writeCommandScript(list, fileWriter, databaseMetaData);
        return new PureQueryUtility.UtilityResult(PureQueryUtility.UtilityResultType.SUCCESS);
    }
}

